/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.registration;

import dev.arketec.redstonedirt.registration.ModBlocks;
import dev.arketec.redstonedirt.registration.ModColors;
import dev.arketec.redstonedirt.registration.ModTileEntityTypes;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistrationManager {
    public static final DeferredRegister<Block> BLOCKS = RegistrationManager.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<MenuType<?>> CONTAINERS = RegistrationManager.create(ForgeRegistries.CONTAINERS);
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = RegistrationManager.create(ForgeRegistries.BLOCK_ENTITIES);
    public static final DeferredRegister<Item> ITEMS = RegistrationManager.create(ForgeRegistries.ITEMS);

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ModBlocks.register();
        ModTileEntityTypes.register();
        modEventBus.addListener(RegistrationManager::clientSetup);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ModColors.registerBlockColors();
        ModColors.registerItemColors();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.REDSTONE_GRASS.get()), (RenderType)RenderType.m_110463_());
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"redstonedirt");
    }
}

