/*
 * Decompiled with CFR 0.152.
 */
package net.cursedwarrior.rivertreasures.init;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.cursedwarrior.rivertreasures.world.features.ores.ClayTreasureFeature;
import net.cursedwarrior.rivertreasures.world.features.ores.DirtTreasureFeature;
import net.cursedwarrior.rivertreasures.world.features.ores.GravelTreasureFeature;
import net.cursedwarrior.rivertreasures.world.features.ores.SandTreasureFeature;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RiverTreasuresModFeatures {
    private static final Map<Feature<?>, FeatureRegistration> REGISTRY = new HashMap();

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])REGISTRY.keySet().toArray(new Feature[0]));
        REGISTRY.forEach((feature, registration) -> Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)feature.getRegistryName(), registration.configuredFeature()));
    }

    static {
        REGISTRY.put((Feature<?>)DirtTreasureFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DirtTreasureFeature.GENERATE_BIOMES, DirtTreasureFeature.CONFIGURED_FEATURE));
        REGISTRY.put((Feature<?>)SandTreasureFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SandTreasureFeature.GENERATE_BIOMES, SandTreasureFeature.CONFIGURED_FEATURE));
        REGISTRY.put((Feature<?>)GravelTreasureFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, GravelTreasureFeature.GENERATE_BIOMES, GravelTreasureFeature.CONFIGURED_FEATURE));
        REGISTRY.put((Feature<?>)ClayTreasureFeature.FEATURE, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, ClayTreasureFeature.GENERATE_BIOMES, ClayTreasureFeature.CONFIGURED_FEATURE));
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, ConfiguredFeature<?, ?> configuredFeature) {
    }

    @Mod.EventBusSubscriber
    private static class BiomeFeatureLoader {
        private BiomeFeatureLoader() {
        }

        @SubscribeEvent
        public static void addFeatureToBiomes(BiomeLoadingEvent event) {
            for (FeatureRegistration registration : REGISTRY.values()) {
                if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
                event.getGeneration().getFeatures(registration.stage()).add(() -> registration.configuredFeature());
            }
        }
    }
}

