/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.campfire.colors;

import com.cozary.tintedcampfires.campfire.colorsTile.LimeTile;
import com.cozary.tintedcampfires.init.ModTiles;
import com.cozary.tintedcampfires.particles.ParticleList;
import java.util.Optional;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LimeCampfire
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.f_61450_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final int SMOKE_DISTANCE = 5;
    private final boolean spawnParticles;
    private final int fireDamage;

    public LimeCampfire() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76370_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60953_(LimeCampfire.litBlockEmission(15)).m_60955_());
        this.spawnParticles = true;
        this.fireDamage = 1;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void dowse(@Nullable Entity p_152750_, LevelAccessor p_152751_, BlockPos p_152752_, BlockState p_152753_) {
        BlockEntity blockentity;
        if (p_152751_.m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                LimeCampfire.makeParticles((Level)p_152751_, p_152752_, (Boolean)p_152753_.m_61143_((Property)SIGNAL_FIRE), true);
            }
        }
        if ((blockentity = p_152751_.m_7702_(p_152752_)) instanceof LimeTile) {
            ((LimeTile)blockentity).dowse();
        }
        p_152751_.m_142346_(p_152750_, GameEvent.f_157792_, p_152752_);
    }

    public static void makeParticles(Level p_51252_, BlockPos p_51253_, boolean p_51254_, boolean p_51255_) {
        Random random = p_51252_.m_5822_();
        SimpleParticleType simpleparticletype = p_51254_ ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        p_51252_.m_6485_((ParticleOptions)simpleparticletype, true, (double)p_51253_.m_123341_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)p_51253_.m_123342_() + random.nextDouble() + random.nextDouble(), (double)p_51253_.m_123343_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (p_51255_) {
            p_51252_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p_51253_.m_123341_() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), (double)p_51253_.m_123342_() + 0.4, (double)p_51253_.m_123343_() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isSmokeyPos(Level p_51249_, BlockPos p_51250_) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos blockpos = p_51250_.m_6625_(i);
            BlockState blockstate = p_51249_.m_8055_(blockpos);
            if (LimeCampfire.isLitCampfire(blockstate)) {
                return true;
            }
            boolean flag = Shapes.m_83157_((VoxelShape)VIRTUAL_FENCE_POST, (VoxelShape)blockstate.m_60742_((BlockGetter)p_51249_, blockpos, CollisionContext.m_82749_()), (BooleanOp)BooleanOp.f_82689_);
            if (!flag) continue;
            BlockState blockstate1 = p_51249_.m_8055_(blockpos.m_7495_());
            return LimeCampfire.isLitCampfire(blockstate1);
        }
        return false;
    }

    public static boolean isLitCampfire(BlockState p_51320_) {
        return p_51320_.m_61138_((Property)LIT) && p_51320_.m_60620_((Tag)BlockTags.f_13087_) && (Boolean)p_51320_.m_61143_((Property)LIT) != false;
    }

    public static boolean canLight(BlockState p_51322_) {
        return p_51322_.m_60622_((Tag)BlockTags.f_13087_, p_51262_ -> p_51262_.m_61138_((Property)WATERLOGGED) && p_51262_.m_61138_((Property)LIT)) && (Boolean)p_51322_.m_61143_((Property)WATERLOGGED) == false && (Boolean)p_51322_.m_61143_((Property)LIT) == false;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.m_61143_((Property)BlockStateProperties.f_61443_) != false ? p_50760_ : 0;
    }

    public InteractionResult m_6227_(BlockState p_51274_, Level p_51275_, BlockPos p_51276_, Player p_51277_, InteractionHand p_51278_, BlockHitResult p_51279_) {
        BlockEntity blockentity = p_51275_.m_7702_(p_51276_);
        if (blockentity instanceof LimeTile) {
            if (p_51277_.m_21120_(p_51278_).m_41720_() instanceof ShovelItem && ((Boolean)p_51274_.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                p_51275_.m_46597_(p_51276_, (BlockState)p_51274_.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                p_51275_.m_142346_((Entity)p_51277_, GameEvent.f_157797_, p_51276_);
                if (p_51277_ != null && !p_51277_.m_150110_().f_35937_) {
                    p_51277_.m_21120_(p_51278_).m_41622_(1, (LivingEntity)p_51277_, p_41303_ -> p_41303_.m_21190_(p_51278_));
                }
                return InteractionResult.m_19078_((boolean)p_51275_.f_46443_);
            }
            if (p_51277_.m_21120_(p_51278_).m_41720_() instanceof FireChargeItem && !((Boolean)p_51274_.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                p_51275_.m_46597_(p_51276_, (BlockState)p_51274_.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                p_51275_.m_142346_((Entity)p_51277_, GameEvent.f_157797_, p_51276_);
                if (!p_51277_.m_150110_().f_35937_) {
                    p_51277_.m_21120_(p_51278_).m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)p_51275_.f_46443_);
            }
            if (p_51277_.m_21120_(p_51278_).m_41720_() instanceof FlintAndSteelItem && !((Boolean)p_51274_.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                p_51275_.m_46597_(p_51276_, (BlockState)p_51274_.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                p_51275_.m_142346_((Entity)p_51277_, GameEvent.f_157797_, p_51276_);
                if (p_51277_ != null && !p_51277_.m_150110_().f_35937_) {
                    p_51277_.m_21120_(p_51278_).m_41622_(1, (LivingEntity)p_51277_, p_41303_ -> p_41303_.m_21190_(p_51278_));
                }
                return InteractionResult.m_19078_((boolean)p_51275_.f_46443_);
            }
            LimeTile campfireblockentity = (LimeTile)blockentity;
            ItemStack itemstack = p_51277_.m_21120_(p_51278_);
            Optional<CampfireCookingRecipe> optional = campfireblockentity.getCookableRecipe(itemstack);
            if (optional.isPresent()) {
                if (!p_51275_.f_46443_ && campfireblockentity.placeFood(p_51277_.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack, optional.get().m_43753_())) {
                    p_51277_.m_36220_(Stats.f_12975_);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState p_51269_, Level p_51270_, BlockPos p_51271_, Entity p_51272_) {
        if (!p_51272_.m_5825_() && ((Boolean)p_51269_.m_61143_((Property)LIT)).booleanValue() && p_51272_ instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)p_51272_))) {
            p_51272_.m_6469_(DamageSource.f_19305_, (float)this.fireDamage);
        }
        super.m_7892_(p_51269_, p_51270_, p_51271_, p_51272_);
    }

    public void m_6810_(BlockState p_51281_, Level p_51282_, BlockPos p_51283_, BlockState p_51284_, boolean p_51285_) {
        if (!p_51281_.m_60713_(p_51284_.m_60734_())) {
            BlockEntity blockentity = p_51282_.m_7702_(p_51283_);
            if (blockentity instanceof LimeTile) {
                Containers.m_19010_((Level)p_51282_, (BlockPos)p_51283_, ((LimeTile)blockentity).getItems());
            }
            super.m_6810_(p_51281_, p_51282_, p_51283_, p_51284_, p_51285_);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_51240_) {
        BlockPos blockpos;
        Level levelaccessor = p_51240_.m_43725_();
        boolean flag = levelaccessor.m_6425_(blockpos = p_51240_.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(levelaccessor.m_8055_(blockpos.m_7495_()))))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!flag))).m_61124_((Property)FACING, (Comparable)p_51240_.m_8125_());
    }

    public BlockState m_7417_(BlockState p_51298_, Direction p_51299_, BlockState p_51300_, LevelAccessor p_51301_, BlockPos p_51302_, BlockPos p_51303_) {
        if (((Boolean)p_51298_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51301_.m_6217_().m_5945_(p_51302_, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51301_));
        }
        return p_51299_ == Direction.DOWN ? (BlockState)p_51298_.m_61124_((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(p_51300_))) : super.m_7417_(p_51298_, p_51299_, p_51300_, p_51301_, p_51302_, p_51303_);
    }

    private boolean isSmokeSource(BlockState p_51324_) {
        return p_51324_.m_60713_(Blocks.f_50335_);
    }

    public VoxelShape m_5940_(BlockState p_51309_, BlockGetter p_51310_, BlockPos p_51311_, CollisionContext p_51312_) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState p_51307_) {
        return RenderShape.MODEL;
    }

    public void m_7100_(BlockState p_51287_, Level p_51288_, BlockPos p_51289_, Random p_51290_) {
        if (((Boolean)p_51287_.m_61143_((Property)LIT)).booleanValue()) {
            if (p_51290_.nextInt(10) == 0) {
                p_51288_.m_7785_((double)p_51289_.m_123341_() + 0.5, (double)p_51289_.m_123342_() + 0.5, (double)p_51289_.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + p_51290_.nextFloat(), p_51290_.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.spawnParticles && p_51290_.nextInt(5) == 0) {
                for (int i = 0; i < p_51290_.nextInt(1) + 1; ++i) {
                    p_51288_.m_7106_((ParticleOptions)ParticleList.LIME_LAVA.get(), (double)p_51289_.m_123341_() + 0.5, (double)p_51289_.m_123342_() + 0.5, (double)p_51289_.m_123343_() + 0.5, (double)(p_51290_.nextFloat() / 2.0f), 5.0E-5, (double)(p_51290_.nextFloat() / 2.0f));
                }
            }
        }
    }

    public boolean m_7361_(LevelAccessor p_51257_, BlockPos p_51258_, BlockState p_51259_, FluidState p_51260_) {
        if (!((Boolean)p_51259_.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && p_51260_.m_76152_() == Fluids.f_76193_) {
            boolean flag = (Boolean)p_51259_.m_61143_((Property)LIT);
            if (flag) {
                if (!p_51257_.m_5776_()) {
                    p_51257_.m_5594_(null, p_51258_, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                LimeCampfire.dowse(null, p_51257_, p_51258_, p_51259_);
            }
            p_51257_.m_7731_(p_51258_, (BlockState)((BlockState)p_51259_.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            p_51257_.m_6217_().m_5945_(p_51258_, (Object)p_51260_.m_76152_(), p_51260_.m_76152_().m_6718_((LevelReader)p_51257_));
            return true;
        }
        return false;
    }

    public void m_5581_(Level p_51244_, BlockState p_51245_, BlockHitResult p_51246_, Projectile p_51247_) {
        BlockPos blockpos = p_51246_.m_82425_();
        if (!p_51244_.f_46443_ && p_51247_.m_6060_() && p_51247_.m_142265_(p_51244_, blockpos) && !((Boolean)p_51245_.m_61143_((Property)LIT)).booleanValue() && !((Boolean)p_51245_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51244_.m_7731_(blockpos, (BlockState)p_51245_.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public FluidState m_5888_(BlockState p_51318_) {
        return (Boolean)p_51318_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51318_);
    }

    public BlockState m_6843_(BlockState p_51295_, Rotation p_51296_) {
        return (BlockState)p_51295_.m_61124_((Property)FACING, (Comparable)p_51296_.m_55954_((Direction)p_51295_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_51292_, Mirror p_51293_) {
        return p_51292_.m_60717_(p_51293_.m_54846_((Direction)p_51292_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51305_) {
        p_51305_.m_61104_(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING});
    }

    public BlockEntity m_142194_(BlockPos p_152759_, BlockState p_152760_) {
        return new LimeTile(p_152759_, p_152760_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        if (p_152755_.f_46443_) {
            return (Boolean)p_152756_.m_61143_((Property)LIT) != false ? LimeCampfire.m_152132_(p_152757_, (BlockEntityType)((BlockEntityType)ModTiles.LIME_CAMPFIRE_TILE.get()), LimeTile::particleTick) : null;
        }
        return (Boolean)p_152756_.m_61143_((Property)LIT) != false ? LimeCampfire.m_152132_(p_152757_, (BlockEntityType)((BlockEntityType)ModTiles.LIME_CAMPFIRE_TILE.get()), LimeTile::cookTick) : LimeCampfire.m_152132_(p_152757_, (BlockEntityType)((BlockEntityType)ModTiles.LIME_CAMPFIRE_TILE.get()), LimeTile::cooldownTick);
    }

    public boolean m_7357_(BlockState p_51264_, BlockGetter p_51265_, BlockPos p_51266_, PathComputationType p_51267_) {
        return false;
    }
}

