/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.campfire.colorsTile;

import com.cozary.tintedcampfires.campfire.colors.YellowCampfire;
import com.cozary.tintedcampfires.init.ModTiles;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class YellowTile
extends BlockEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];

    public YellowTile(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModTiles.YELLOW_CAMPFIRE_TILE.get(), blockPos, blockState);
    }

    public static void cookTick(Level p_155307_, BlockPos p_155308_, BlockState p_155309_, YellowTile p_155310_) {
        boolean flag = false;
        for (int i = 0; i < p_155310_.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)p_155310_.items.get(i);
            if (itemstack.m_41619_()) continue;
            flag = true;
            int n = i;
            p_155310_.cookingProgress[n] = p_155310_.cookingProgress[n] + 1;
            if (p_155310_.cookingProgress[i] < p_155310_.cookingTime[i]) continue;
            SimpleContainer container = new SimpleContainer(new ItemStack[]{itemstack});
            ItemStack itemstack1 = p_155307_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)container, p_155307_).map(arg_0 -> YellowTile.lambda$cookTick$0((Container)container, arg_0)).orElse(itemstack);
            Containers.m_18992_((Level)p_155307_, (double)p_155308_.m_123341_(), (double)p_155308_.m_123342_(), (double)p_155308_.m_123343_(), (ItemStack)itemstack1);
            p_155310_.items.set(i, (Object)ItemStack.f_41583_);
            p_155307_.m_7260_(p_155308_, p_155309_, p_155309_, 3);
        }
        if (flag) {
            YellowTile.m_155232_((Level)p_155307_, (BlockPos)p_155308_, (BlockState)p_155309_);
        }
    }

    public static void cooldownTick(Level p_155314_, BlockPos p_155315_, BlockState p_155316_, YellowTile p_155317_) {
        boolean flag = false;
        for (int i = 0; i < p_155317_.items.size(); ++i) {
            if (p_155317_.cookingProgress[i] <= 0) continue;
            flag = true;
            p_155317_.cookingProgress[i] = Mth.m_14045_((int)(p_155317_.cookingProgress[i] - 2), (int)0, (int)p_155317_.cookingTime[i]);
        }
        if (flag) {
            YellowTile.m_155232_((Level)p_155314_, (BlockPos)p_155315_, (BlockState)p_155316_);
        }
    }

    public static void particleTick(Level p_155319_, BlockPos p_155320_, BlockState p_155321_, YellowTile p_155322_) {
        Random random = p_155319_.f_46441_;
        if (random.nextFloat() < 0.11f) {
            for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                YellowCampfire.makeParticles(p_155319_, p_155320_, (Boolean)p_155321_.m_61143_((Property)YellowCampfire.SIGNAL_FIRE), false);
            }
        }
        int l = ((Direction)p_155321_.m_61143_((Property)YellowCampfire.FACING)).m_122416_();
        for (int j = 0; j < p_155322_.items.size(); ++j) {
            if (((ItemStack)p_155322_.items.get(j)).m_41619_() || !(random.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.m_122407_((int)Math.floorMod(j + l, 4));
            float f = 0.3125f;
            double d0 = (double)p_155320_.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * 0.3125f) + (double)((float)direction.m_122427_().m_122429_() * 0.3125f);
            double d1 = (double)p_155320_.m_123342_() + 0.5;
            double d2 = (double)p_155320_.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * 0.3125f) + (double)((float)direction.m_122427_().m_122431_() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                p_155319_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag p_155312_) {
        super.m_142466_(p_155312_);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)p_155312_, this.items);
        if (p_155312_.m_128425_("CookingTimes", 11)) {
            int[] aint = p_155312_.m_128465_("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (p_155312_.m_128425_("CookingTotalTimes", 11)) {
            int[] aint1 = p_155312_.m_128465_("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
    }

    public CompoundTag m_6945_(CompoundTag p_59060_) {
        this.saveMetadataAndItems(p_59060_);
        p_59060_.m_128385_("CookingTimes", this.cookingProgress);
        p_59060_.m_128385_("CookingTotalTimes", this.cookingTime);
        return p_59060_;
    }

    private CompoundTag saveMetadataAndItems(CompoundTag p_59064_) {
        super.m_6945_(p_59064_);
        ContainerHelper.m_18976_((CompoundTag)p_59064_, this.items, (boolean)true);
        return p_59064_;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 13, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.saveMetadataAndItems(new CompoundTag());
    }

    public Optional<CampfireCookingRecipe> getCookableRecipe(ItemStack p_59052_) {
        return this.items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{p_59052_}), this.f_58857_);
    }

    public boolean placeFood(ItemStack p_59054_, int p_59055_) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.m_41619_()) continue;
            this.cookingTime[i] = p_59055_;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)p_59054_.m_41620_(1));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void dowse() {
        if (this.f_58857_ != null) {
            this.markUpdated();
        }
    }

    private static /* synthetic */ ItemStack lambda$cookTick$0(Container container, CampfireCookingRecipe p_155305_) {
        return p_155305_.m_5874_(container);
    }
}

