/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.campfire.colors;

import com.cozary.tintedcampfires.campfire.colorsTile.CyanTile;
import com.cozary.tintedcampfires.particles.ParticleList;
import java.util.Optional;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class CyanCampfire
extends ContainerBlock
implements IWaterLoggable {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.field_222516_y;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape SMOKING_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final boolean smokey;
    private final int fireDamage;

    public CyanCampfire() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a).func_235838_a_(CyanCampfire.getLightValueLit(15)).func_226896_b_());
        this.smokey = true;
        this.fireDamage = 2;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightValue : 0;
    }

    public static void spawnSmokeParticles(World worldIn, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        Random random = worldIn.func_201674_k();
        BasicParticleType basicparticletype = isSignalFire ? ParticleTypes.field_218418_af : ParticleTypes.field_218417_ae;
        worldIn.func_217404_b((IParticleData)basicparticletype, true, (double)pos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)pos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static void extinguish(IWorld world, BlockPos pos, BlockState state) {
        TileEntity tileentity;
        if (world.func_201670_d()) {
            for (int i = 0; i < 20; ++i) {
                CyanCampfire.spawnSmokeParticles((World)world, pos, (Boolean)state.func_177229_b((Property)SIGNAL_FIRE), true);
            }
        }
        if ((tileentity = world.func_175625_s(pos)) instanceof CyanTile) {
            ((CyanTile)tileentity).dropAllItems();
        }
    }

    public static boolean isLit(BlockState state) {
        return state.func_235901_b_((Property)LIT) && state.func_235714_a_((ITag)BlockTags.field_232882_ax_) && (Boolean)state.func_177229_b((Property)LIT) != false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack;
        CyanTile campfiretileentity;
        Optional<CampfireCookingRecipe> optional;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CyanTile && (optional = (campfiretileentity = (CyanTile)tileentity).findMatchingRecipe(itemstack = player.func_184586_b(handIn))).isPresent()) {
            if (!worldIn.field_72995_K && campfiretileentity.addItem(player.field_71075_bZ.field_75098_d ? itemstack.func_77946_l() : itemstack, optional.get().func_222137_e())) {
                player.func_195066_a(Stats.field_219736_at);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_230279_az_() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_76372_a, (float)this.fireDamage);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CyanTile) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((CyanTile)tileentity).getInventory());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos;
        World iworld = context.func_195991_k();
        boolean flag = iworld.func_204610_c(blockpos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isHayBlock(iworld.func_180495_p(blockpos.func_177977_b()))))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(!flag))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN ? (BlockState)stateIn.func_206870_a((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isHayBlock(facingState))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private boolean isHayBlock(BlockState stateIn) {
        return stateIn.func_203425_a(Blocks.field_150407_cf);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.smokey && rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleList.CYAN_LAVA.get(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean flag = (Boolean)state.func_177229_b((Property)LIT);
            if (flag) {
                if (!worldIn.func_201670_d()) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                CyanCampfire.extinguish(worldIn, pos, state);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (!worldIn.field_72995_K && projectile.func_70027_ad()) {
            boolean flag;
            Entity entity = projectile.func_234616_v_();
            boolean bl = flag = entity == null || entity instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity);
            if (flag && !((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.func_216350_a();
                worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CyanTile();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

