/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.tintedcampfires.campfire.colorsTile;

import com.cozary.tintedcampfires.campfire.colors.LimeCampfire;
import com.cozary.tintedcampfires.init.ModTiles;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class LimeTile
extends TileEntity
implements IClearable,
ITickableTileEntity {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];

    public LimeTile() {
        super((TileEntityType)ModTiles.LIME_CAMPFIRE_TILE.get());
    }

    public void func_73660_a() {
        boolean flag = (Boolean)this.func_195044_w().func_177229_b((Property)LimeCampfire.LIT);
        boolean flag1 = this.field_145850_b.field_72995_K;
        if (flag1) {
            if (flag) {
                this.addParticles();
            }
        } else if (flag) {
            this.cookAndDrop();
        } else {
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (this.cookingTimes[i] <= 0) continue;
                this.cookingTimes[i] = MathHelper.func_76125_a((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTotalTimes[i]);
            }
        }
    }

    private void cookAndDrop() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventory.get(i);
            if (itemstack.func_190926_b()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTotalTimes[i]) continue;
            Inventory iinventory = new Inventory(new ItemStack[]{itemstack});
            ItemStack itemstack1 = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)iinventory, this.field_145850_b).map(arg_0 -> LimeTile.lambda$cookAndDrop$0((IInventory)iinventory, arg_0)).orElse(itemstack);
            BlockPos blockpos = this.func_174877_v();
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (ItemStack)itemstack1);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            this.inventoryChanged();
        }
    }

    private void addParticles() {
        World world = this.func_145831_w();
        if (world != null) {
            BlockPos blockpos = this.func_174877_v();
            Random random = world.field_73012_v;
            if (random.nextFloat() < 0.11f) {
                for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                    LimeCampfire.spawnSmokeParticles(world, blockpos, (Boolean)this.func_195044_w().func_177229_b((Property)LimeCampfire.SIGNAL_FIRE), false);
                }
            }
            int l = ((Direction)this.func_195044_w().func_177229_b((Property)LimeCampfire.FACING)).func_176736_b();
            for (int j = 0; j < this.inventory.size(); ++j) {
                if (((ItemStack)this.inventory.get(j)).func_190926_b() || !(random.nextFloat() < 0.2f)) continue;
                Direction direction = Direction.func_176731_b((int)Math.floorMod(j + l, 4));
                float f = 0.3125f;
                double d0 = (double)blockpos.func_177958_n() + 0.5 - (double)((float)direction.func_82601_c() * 0.3125f) + (double)((float)direction.func_176746_e().func_82601_c() * 0.3125f);
                double d1 = (double)blockpos.func_177956_o() + 0.5;
                double d2 = (double)blockpos.func_177952_p() + 0.5 - (double)((float)direction.func_82599_e() * 0.3125f) + (double)((float)direction.func_176746_e().func_82599_e() * 0.3125f);
                for (int k = 0; k < 4; ++k) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        if (nbt.func_150297_b("CookingTimes", 11)) {
            int[] aint = nbt.func_74759_k("CookingTimes");
            System.arraycopy(aint, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, aint.length));
        }
        if (nbt.func_150297_b("CookingTotalTimes", 11)) {
            int[] aint1 = nbt.func_74759_k("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, aint1.length));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeItems(compound);
        compound.func_74783_a("CookingTimes", this.cookingTimes);
        compound.func_74783_a("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private CompoundNBT writeItems(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)true);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 13, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    public Optional<CampfireCookingRecipe> findMatchingRecipe(ItemStack itemStackIn) {
        return this.inventory.stream().noneMatch(ItemStack::func_190926_b) ? Optional.empty() : this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)new Inventory(new ItemStack[]{itemStackIn}), this.field_145850_b);
    }

    public boolean addItem(ItemStack itemStackIn, int cookTime) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventory.get(i);
            if (!itemstack.func_190926_b()) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.inventory.set(i, (Object)itemStackIn.func_77979_a(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    private void inventoryChanged() {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void dropAllItems() {
        if (this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), this.getInventory());
            }
            this.inventoryChanged();
        }
    }

    private static /* synthetic */ ItemStack lambda$cookAndDrop$0(IInventory iinventory, CampfireCookingRecipe campfireRecipe) {
        return campfireRecipe.func_77572_b(iinventory);
    }
}

