/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.allay.mobs;

import com.minecraftserverzone.allay.registrations.Registrations;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Allay
extends TamableAnimal
implements NeutralMob,
FlyingAnimal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Allay.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Allay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(Allay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_GLOW = SynchedEntityData.m_135353_(Allay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_, Items.f_41984_, Items.f_41859_, Items.f_42710_, Items.f_42752_, Items.f_42702_, Items.f_42701_, Items.f_42703_, Items.f_42704_, Items.f_42705_, Items.f_42706_, Items.f_42712_, Items.f_42707_, Items.f_42708_, Items.f_42711_, Items.f_42709_});
    public static final String TAG_NoteBlock_POS = "NoteBlockPos";
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    int ticksWithoutItemSinceExitingNoteBlock;
    @Nullable
    BlockPos savedNoteBlockPos;
    public float dancing;

    public Allay(EntityType<? extends Allay> p_27717_, Level p_27718_) {
        super(p_27717_, p_27718_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new AllayLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21553_(true);
        this.m_7105_(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)DyeColor.LIGHT_BLUE.m_41060_());
        this.f_19804_.m_135372_(DATA_GLOW, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public float m_5610_(BlockPos p_27788_, LevelReader p_27789_) {
        return p_27789_.m_8055_(p_27788_).m_60795_() ? 10.0f : 0.0f;
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLOR)));
    }

    public void setColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_.m_41060_());
    }

    public int getGlow() {
        return (Integer)this.f_19804_.m_135370_(DATA_GLOW);
    }

    public void setGlow(int p_30398_) {
        this.f_19804_.m_135381_(DATA_GLOW, (Object)p_30398_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AllayAttackGoal((PathfinderMob)this, 1.4f, true));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AllayWanderGoal());
        this.f_21346_.m_25352_(1, (Goal)new AllayHurtByOtherGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new AllayBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean m_7848_(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(p_30392_ instanceof Allay)) {
            return false;
        }
        Allay Allay2 = (Allay)p_30392_;
        if (!Allay2.m_21824_()) {
            return false;
        }
        if (Allay2.m_21825_()) {
            return false;
        }
        return this.m_27593_() && Allay2.m_27593_();
    }

    public Allay getBreedOffspring(ServerLevel p_149088_, AgeableMob p_149089_) {
        Allay allay = (Allay)((EntityType)Registrations.ALLAY.get()).m_20615_((Level)p_149088_);
        UUID uuid = this.m_142504_();
        if (uuid != null) {
            allay.m_21816_(uuid);
            allay.m_7105_(true);
        }
        return allay;
    }

    public boolean m_7757_(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (p_30389_ instanceof Allay) {
            Allay Allay2 = (Allay)p_30389_;
            return !Allay2.m_21824_() || Allay2.m_142480_() != p_30390_;
        }
        if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
            return false;
        }
        if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
            return false;
        }
        return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
    }

    public void m_7380_(CompoundTag p_27823_) {
        super.m_7380_(p_27823_);
        if (this.hasNoteBlock()) {
            p_27823_.m_128365_(TAG_NoteBlock_POS, (net.minecraft.nbt.Tag)NbtUtils.m_129224_((BlockPos)this.getNoteBlockPos()));
        }
        p_27823_.m_128344_("Color", (byte)this.getColor().m_41060_());
        p_27823_.m_128344_("Glow", (byte)this.getGlow());
        this.m_21678_(p_27823_);
    }

    public void m_7378_(CompoundTag p_27793_) {
        this.savedNoteBlockPos = null;
        if (p_27793_.m_128441_(TAG_NoteBlock_POS)) {
            this.savedNoteBlockPos = NbtUtils.m_129239_((CompoundTag)p_27793_.m_128469_(TAG_NoteBlock_POS));
        }
        if (p_27793_.m_128425_("Color", 99)) {
            this.setColor(DyeColor.m_41053_((int)p_27793_.m_128451_("Color")));
        }
        if (p_27793_.m_128425_("Glow", 99)) {
            this.setGlow(p_27793_.m_128451_("Glow"));
        }
        super.m_7378_(p_27793_);
        this.m_147285_(this.f_19853_, p_27793_);
    }

    public boolean m_7252_(ItemStack p_28578_) {
        p_28578_.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_();
    }

    public boolean m_7327_(Entity p_27722_) {
        boolean flag = p_27722_.m_6469_(DamageSource.m_19364_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_27722_);
        }
        this.m_21662_();
        return flag;
    }

    public void m_8119_() {
        if (this.hasSavedNoteBlocPos() && this.m_20275_(this.savedNoteBlockPos.m_123341_(), this.savedNoteBlockPos.m_123342_(), this.savedNoteBlockPos.m_123343_()) < 10.0 && this.dancing < 2.0f) {
            this.dancing = 100.0f;
            this.f_19853_.m_7605_((Entity)this, (byte)56);
        }
        if (this.getDancingTick() > 0.0f) {
            if (this.dancing % 5.0f == 0.0f) {
                this.spawnFluidParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_175827_);
            }
            this.dancing -= 1.0f;
        }
        super.m_8119_();
    }

    private void spawnFluidParticle(Level p_27780_, double p_27781_, double p_27782_, double p_27783_, double p_27784_, double p_27785_, ParticleOptions p_27786_) {
        p_27780_.m_7106_(p_27786_, Mth.m_14139_((double)p_27780_.f_46441_.nextDouble(), (double)p_27781_, (double)p_27782_), p_27785_, Mth.m_14139_((double)p_27780_.f_46441_.nextDouble(), (double)p_27783_, (double)p_27784_), 0.0, 0.0, 0.0);
    }

    void pathfindRandomlyTowards(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.m_142538_();
        int j = (int)vec3.f_82480_ - blockpos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.m_123333_((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.2);
        }
    }

    @Nullable
    public BlockPos getSavedNoteBlockPos() {
        return this.savedNoteBlockPos;
    }

    public boolean hasSavedNoteBlocPos() {
        return this.savedNoteBlockPos != null;
    }

    public void setSavedNoteBlockPos(BlockPos p_27877_) {
        this.savedNoteBlockPos = p_27877_;
    }

    private boolean isTiredOfLookingForItem() {
        return this.ticksWithoutItemSinceExitingNoteBlock > 2400;
    }

    protected void m_8024_() {
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
            if (!this.m_21033_(EquipmentSlot.MAINHAND)) {
                this.resetTicksWithoutItemSinceExitingNoteBlock();
            }
            if (this.m_21033_(EquipmentSlot.MAINHAND) && !this.m_21033_(EquipmentSlot.OFFHAND)) {
                ++this.ticksWithoutItemSinceExitingNoteBlock;
            }
        }
    }

    public void resetTicksWithoutItemSinceExitingNoteBlock() {
        this.ticksWithoutItemSinceExitingNoteBlock = 0;
    }

    public InteractionResult m_6071_(Player p_28861_, InteractionHand p_28862_) {
        if (this.f_19853_.f_46443_) {
            boolean flag = !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        ItemStack itemstack = p_28861_.m_21120_(p_28862_);
        ItemStack newitemstack = p_28861_.m_21205_().m_41777_();
        newitemstack.m_41764_(1);
        if (this.m_21824_()) {
            if (itemstack.m_41619_()) {
                InteractionResult interactionresult;
                if (this.m_21033_(EquipmentSlot.MAINHAND)) {
                    this.m_19983_(this.m_21205_());
                    this.m_19983_(this.m_21206_());
                    this.m_21468_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    this.m_21468_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                if ((!(interactionresult = super.m_6071_(p_28861_, p_28862_)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)p_28861_)) {
                    this.savedNoteBlockPos = null;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            if (itemstack.m_150930_(Items.f_42572_) && !this.m_21660_()) {
                return super.m_6071_(p_28861_, p_28862_);
            }
        } else if (itemstack.m_150930_(Items.f_42572_) && !this.m_21660_()) {
            if (!p_28861_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_28861_)) {
                this.m_21828_(p_28861_);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.savedNoteBlockPos = null;
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_41852_) {
            if (this.m_21033_(EquipmentSlot.MAINHAND)) {
                this.m_19983_(this.m_21205_());
                this.m_19983_(this.m_21206_());
                this.m_21468_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.m_21468_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_151056_) {
            if (this.getGlow() == 0) {
                this.setGlow(1);
                if (!p_28861_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_42532_) {
            if (this.getGlow() == 1) {
                this.setGlow(0);
                if (!p_28861_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!(itemstack.m_41720_() instanceof DyeItem)) {
            if (this.m_21033_(EquipmentSlot.MAINHAND)) {
                this.m_19983_(this.m_21205_());
                this.m_19983_(this.m_21206_());
                this.m_21468_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            this.m_21468_(EquipmentSlot.MAINHAND, newitemstack);
            this.m_146859_(GameEvent.f_157771_, this.m_146901_());
            if (!p_28861_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        DyeColor dyecolor = ((DyeItem)itemstack.m_41720_()).m_41089_();
        if (dyecolor != this.getColor()) {
            this.setColor(dyecolor);
            if (!p_28861_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_28861_, p_28862_);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_27795_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_27795_);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_27791_) {
        this.persistentAngerTarget = p_27791_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    @VisibleForDebug
    public boolean hasNoteBlock() {
        return this.savedNoteBlockPos != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPos getNoteBlockPos() {
        return this.savedNoteBlockPos;
    }

    @VisibleForDebug
    public GoalSelector getGoalSelector() {
        return this.f_21345_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
    }

    boolean isNoteBlockValid() {
        if (!this.hasNoteBlock()) {
            return false;
        }
        Block block = this.f_19853_.m_8055_(this.savedNoteBlockPos).m_60734_();
        if (!(block instanceof NoteBlock)) {
            this.savedNoteBlockPos = null;
        }
        return block instanceof NoteBlock;
    }

    boolean isTooFarAway(BlockPos p_27890_) {
        return !this.closerThan(p_27890_, 32);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_6898_(ItemStack p_27895_) {
        return p_27895_.m_150930_(Items.f_42572_);
    }

    boolean isNoteBlockValid(BlockPos p_27897_) {
        return this.f_19853_.m_46749_(p_27897_) && this.f_19853_.m_8055_(p_27897_).m_60713_(Blocks.f_50065_);
    }

    protected void m_7355_(BlockPos p_27820_, BlockState p_27821_) {
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected float m_6431_(Pose p_27804_, EntityDimensions p_27805_) {
        return this.m_6162_() ? p_27805_.f_20378_ * 0.5f : p_27805_.f_20378_ * 0.5f;
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    public boolean m_142039_() {
        return this.m_142592_();
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 56) {
            this.dancing = 100.0f;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public float getDancingTick() {
        return this.dancing;
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    public boolean m_6469_(DamageSource p_27762_, float p_27763_) {
        if (this.m_6673_(p_27762_)) {
            return false;
        }
        return super.m_6469_(p_27762_, p_27763_);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_6197_(Tag<Fluid> p_27825_) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    boolean closerThan(BlockPos p_27817_, int p_27818_) {
        return p_27817_.m_123314_((Vec3i)this.m_142538_(), (double)p_27818_);
    }

    public boolean m_6573_(Player p_21418_) {
        return true;
    }

    public boolean m_21224_() {
        return super.m_21224_();
    }

    class AllayLookControl
    extends LookControl {
        AllayLookControl(Mob p_28059_) {
            super(p_28059_);
        }

        public void m_8128_() {
            if (!Allay.this.m_21660_()) {
                super.m_8128_();
            }
        }
    }

    class AllayAttackGoal
    extends MeleeAttackGoal {
        AllayAttackGoal(PathfinderMob p_27960_, double p_27961_, boolean p_27962_) {
            super(p_27960_, p_27961_, p_27962_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Allay.this.m_21660_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && Allay.this.m_21660_();
        }
    }

    class AllayWanderGoal
    extends Goal {
        public Predicate<ItemEntity> ALLOWED_ITEMS = p_29133_ -> {
            ItemStack itemstack = p_29133_.m_32055_();
            return itemstack.m_150930_(Allay.this.m_6844_(EquipmentSlot.MAINHAND).m_41720_()) && p_29133_.m_6084_() && !p_29133_.m_32063_();
        };

        AllayWanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Allay.this.m_27593_();
        }

        public boolean m_8045_() {
            return Allay.this.f_21344_.m_26572_() && Allay.this.m_5448_() == null;
        }

        public BlockPos searchForBlockInDistance(Allay entity, int posx, int posy, int posz) {
            BlockPos blockpos = entity.m_142538_();
            for (int x = -posx; x < posx + 1; ++x) {
                for (int y = -posy; y < posy + 1; ++y) {
                    for (int z = -posz; z < posz + 1; ++z) {
                        if (entity.f_19853_.m_8055_(blockpos.m_142082_(x, y, z)).m_60734_() != Blocks.f_50065_) continue;
                        return blockpos.m_142082_(x, y, z);
                    }
                }
            }
            return null;
        }

        public boolean searchForItemInDistance(Allay entity, double posx, double posy, double posz) {
            int whichNumberFromArrayShouldBeUSed = 0;
            this.ALLOWED_ITEMS = p_29133_ -> {
                ItemStack itemstack = p_29133_.m_32055_();
                return itemstack.m_150930_(Allay.this.m_6844_(EquipmentSlot.MAINHAND).m_41720_()) && p_29133_.m_6084_() && !p_29133_.m_32063_();
            };
            List list = entity.f_19853_.m_6443_(ItemEntity.class, Allay.this.m_142469_().m_82377_(0.0, 0.0, 0.0), this.ALLOWED_ITEMS);
            int i = 1;
            while ((double)i < posx + 1.0) {
                list = entity.f_19853_.m_6443_(ItemEntity.class, Allay.this.m_142469_().m_82377_((double)(i - 1), (double)(i - 1), (double)(i - 1)), this.ALLOWED_ITEMS);
                if (!list.isEmpty()) {
                    for (double x = -4.0; x < 5.0; x += 1.0) {
                        for (double y = -4.0; y < 5.0; y += 1.0) {
                            for (double z = -4.0; z < 5.0; z += 1.0) {
                                for (int listnumber = 0; listnumber < list.size(); ++listnumber) {
                                    ItemEntity currentX = (ItemEntity)list.get(listnumber);
                                    if ((double)currentX.m_142538_().m_123341_() + x != (double)Allay.this.savedNoteBlockPos.m_123341_() || (double)currentX.m_142538_().m_123342_() + y != (double)Allay.this.savedNoteBlockPos.m_123342_() || (double)currentX.m_142538_().m_123343_() + z != (double)Allay.this.savedNoteBlockPos.m_123343_()) continue;
                                    list.remove(currentX);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            if (!list.isEmpty()) {
                int listnumber = 0;
                while (listnumber < list.size()) {
                    whichNumberFromArrayShouldBeUSed = listnumber++;
                }
                entity.m_21573_().m_5624_((Entity)list.get(whichNumberFromArrayShouldBeUSed), (double)1.2f);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            BlockPos isNoteBlockNear = this.searchForBlockInDistance(Allay.this, 20, 20, 20);
            if (!Allay.this.hasSavedNoteBlocPos()) {
                if (isNoteBlockNear == null) {
                    Vec3 vec3 = this.findPos();
                    if (vec3 != null) {
                        Allay.this.f_21344_.m_26536_(Allay.this.f_21344_.m_7864_(new BlockPos(vec3), 1), 1.2);
                    }
                } else {
                    Allay.this.savedNoteBlockPos = isNoteBlockNear;
                    Allay.this.f_21344_.m_26519_((double)Allay.this.savedNoteBlockPos.m_123341_() + 0.5, (double)Allay.this.savedNoteBlockPos.m_123342_() + 2.0, (double)Allay.this.savedNoteBlockPos.m_123343_() + 0.5, (double)1.2f);
                }
            } else if (!Allay.this.isNoteBlockValid()) {
                if (isNoteBlockNear == null) {
                    Vec3 vec3 = this.findPos();
                    if (vec3 != null) {
                        Allay.this.f_21344_.m_26536_(Allay.this.f_21344_.m_7864_(new BlockPos(vec3), 1), 1.2);
                    }
                    return;
                }
                Allay.this.savedNoteBlockPos = isNoteBlockNear;
                Allay.this.f_21344_.m_26519_((double)Allay.this.savedNoteBlockPos.m_123341_() + 0.5, (double)Allay.this.savedNoteBlockPos.m_123342_() + 2.0, (double)Allay.this.savedNoteBlockPos.m_123343_() + 0.5, (double)1.2f);
            } else if (Allay.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                Allay.this.f_21344_.m_26519_((double)Allay.this.savedNoteBlockPos.m_123341_() + 0.5, (double)Allay.this.savedNoteBlockPos.m_123342_() + 2.0, (double)Allay.this.savedNoteBlockPos.m_123343_() + 0.5, (double)1.2f);
            } else {
                if (Allay.this.isTiredOfLookingForItem()) {
                    if (Allay.this.m_20275_(Allay.this.savedNoteBlockPos.m_123341_(), Allay.this.savedNoteBlockPos.m_123342_(), Allay.this.savedNoteBlockPos.m_123343_()) < 20.0) {
                        Allay.this.resetTicksWithoutItemSinceExitingNoteBlock();
                    }
                    Allay.this.f_21344_.m_26519_((double)Allay.this.savedNoteBlockPos.m_123341_() + 0.5, (double)Allay.this.savedNoteBlockPos.m_123342_() + 2.0, (double)Allay.this.savedNoteBlockPos.m_123343_() + 0.5, 2.0);
                    return;
                }
                if (Allay.this.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                    if (this.searchForItemInDistance(Allay.this, 20.0, 20.0, 20.0)) {
                        List list = Allay.this.f_19853_.m_6443_(ItemEntity.class, Allay.this.m_142469_().m_82377_(1.0, 1.0, 1.0), this.ALLOWED_ITEMS);
                        ItemStack itemstack = Allay.this.m_21206_();
                        if (itemstack.m_41619_() && !list.isEmpty()) {
                            Allay.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
                            Allay.this.m_21468_(EquipmentSlot.OFFHAND, ((ItemEntity)list.get(0)).m_32055_());
                            ((ItemEntity)list.get(0)).m_146870_();
                        }
                    } else {
                        Vec3 vec3 = this.findPos();
                        if (vec3 != null) {
                            Allay.this.f_21344_.m_26536_(Allay.this.f_21344_.m_7864_(new BlockPos(vec3), 1), 1.2);
                        }
                    }
                } else {
                    ItemStack itemstack = Allay.this.m_21206_();
                    if (itemstack.m_41753_() && this.searchForItemInDistance(Allay.this, 20.0, 20.0, 20.0)) {
                        List list = Allay.this.f_19853_.m_6443_(ItemEntity.class, Allay.this.m_142469_().m_82377_(1.0, 1.0, 1.0), this.ALLOWED_ITEMS);
                        if (!list.isEmpty()) {
                            Allay.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
                            ItemStack stack = ((ItemEntity)list.get(0)).m_32055_();
                            stack.m_41777_();
                            stack.m_41764_(stack.m_41613_() + itemstack.m_41613_());
                            ((ItemEntity)list.get(0)).m_146870_();
                        }
                    } else {
                        Allay.this.f_21344_.m_26519_((double)Allay.this.savedNoteBlockPos.m_123341_() + 0.5, (double)Allay.this.savedNoteBlockPos.m_123342_() + 2.0, (double)Allay.this.savedNoteBlockPos.m_123343_() + 0.5, (double)1.2f);
                        if (this.searchForBlockInDistance(Allay.this, 4, 4, 4) != null) {
                            Allay.this.resetTicksWithoutItemSinceExitingNoteBlock();
                            ItemStack stack = Allay.this.m_21206_();
                            Allay.this.m_19983_(stack);
                            Allay.this.m_21468_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                        }
                    }
                }
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3;
            if (Allay.this.isNoteBlockValid() && !Allay.this.closerThan(Allay.this.savedNoteBlockPos, 22)) {
                Vec3 vec31 = Vec3.m_82512_((Vec3i)Allay.this.savedNoteBlockPos);
                vec3 = vec31.m_82546_(Allay.this.m_20182_()).m_82541_();
            } else {
                vec3 = Allay.this.m_20252_(0.0f);
            }
            Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)Allay.this, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Allay.this, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    class AllayHurtByOtherGoal
    extends HurtByTargetGoal {
        AllayHurtByOtherGoal(Allay p_28033_) {
            super((PathfinderMob)p_28033_, new Class[0]);
        }

        public boolean m_8045_() {
            return Allay.this.m_21660_() && super.m_8045_();
        }

        protected void m_5766_(Mob p_28035_, LivingEntity p_28036_) {
            if (p_28035_ instanceof Allay && this.f_26135_.m_142582_((Entity)p_28036_)) {
                p_28035_.m_6710_(p_28036_);
            }
        }
    }

    static class AllayBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        AllayBecomeAngryTargetGoal(Allay p_27966_) {
            super((Mob)p_27966_, Player.class, 10, true, false, arg_0 -> ((Allay)p_27966_).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.beeCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean flag = this.beeCanTarget();
            if (flag && this.f_26135_.m_5448_() != null) {
                return super.m_8045_();
            }
            this.f_26137_ = null;
            return false;
        }

        private boolean beeCanTarget() {
            Allay bee = (Allay)this.f_26135_;
            return bee.m_21660_();
        }
    }
}

