/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.allay.registrations.configs;

import net.minecraftforge.common.ForgeConfigSpec;

final class CommonConfig {
    final ForgeConfigSpec.IntValue[] ALLAY = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> ALLAY_BIOME;
    final ForgeConfigSpec.IntValue ALLAY_MODEL;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.ALLAY_BIOME = builder.comment("\nBiome name where the Allay should spawn").define("biome_name", (Object)"minecraft:forest");
        builder.comment("Spawn rate settings").push("spawnrate");
        this.ALLAY_MODEL = builder.comment("Model type to choose from: 0 or 1").translation("allay.config.allay.model_type").defineInRange("type", 0, 0, 1);
        CommonConfig.initMobSpawnRate(builder, "Allay", "allay", 10, 0, 1, this.ALLAY);
        builder.pop();
    }

    public static void initMobSpawnRate(ForgeConfigSpec.Builder builder, String name, String pushname, int weight, int min, int max, ForgeConfigSpec.IntValue[] array) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Spawn Chance").translation("allay.config." + name + "weight").defineInRange("weight", weight, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("Monster Spawn Minimum Number").translation("allay.config." + name + "min").defineInRange("min", min, 0, Integer.MAX_VALUE);
        array[2] = builder.comment("Monster Spawn Maximum Number").translation("allay.config." + name + "max").defineInRange("max", max, 0, Integer.MAX_VALUE);
        builder.pop();
    }
}

