/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.allay;

import com.minecraftserverzone.allay.mobs.Allay;
import com.minecraftserverzone.allay.mobs.AllayModel;
import com.minecraftserverzone.allay.registrations.MyModelLayers;
import com.minecraftserverzone.allay.registrations.Registrations;
import com.minecraftserverzone.allay.registrations.configs.AllayModConfig;
import com.minecraftserverzone.allay.registrations.configs.ConfigHelper;
import com.minecraftserverzone.allay.registrations.configs.ConfigHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod(value="allay")
public class AllayMod {
    public static final String MODID = "allay";

    public AllayMod() {
        Registrations.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.COMMON_SPEC);
    }

    @Mod.EventBusSubscriber(modid="allay", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class ModSetup {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
            if (event.getName() == null) {
                return;
            }
            String biomename = event.getName().toString();
            String[] spawnInBiomesList = ((String)AllayModConfig.ALLAY_BIOME.get()).split(",");
            if ((Integer)AllayModConfig.ALLAY[0].get() > 0) {
                MobSpawnSettingsBuilder spawns = event.getSpawns();
                if (AllayModConfig.ALLAY_BIOME.get() == "") {
                    spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.ALLAY.get(), ((Integer)AllayModConfig.ALLAY[0].get()).intValue(), ((Integer)AllayModConfig.ALLAY[1].get()).intValue(), ((Integer)AllayModConfig.ALLAY[2].get()).intValue()));
                }
                for (String list : spawnInBiomesList) {
                    if (!biomename.equals(list)) continue;
                    spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.ALLAY.get(), ((Integer)AllayModConfig.ALLAY[0].get()).intValue(), ((Integer)AllayModConfig.ALLAY[1].get()).intValue(), ((Integer)AllayModConfig.ALLAY[2].get()).intValue()));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="allay", bus=Mod.EventBusSubscriber.Bus.MOD)
    public class ClientSetup {
        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(MyModelLayers.ALLAY_OUTER_LAYER, AllayModel::createBodyLayer);
            event.registerLayerDefinition(MyModelLayers.ALLAY_LAYER, AllayModel::create);
        }

        @SubscribeEvent
        public static void entityAttributeCreationEvent(EntityAttributeCreationEvent event) {
            event.put((EntityType)Registrations.ALLAY.get(), Allay.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void onModConfigEvent(ModConfigEvent event) {
            if (event.getConfig().getSpec() == ConfigHolder.COMMON_SPEC) {
                ConfigHelper.bakeCommon(event.getConfig());
            }
        }
    }
}

