/*
 * Decompiled with CFR 0.152.
 */
package zerolight.entity;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import zerolight.ZerolightModElements;
import zerolight.entity.renderer.FurryRenderer;
import zerolight.itemgroup.ZeroLightTabItemGroup;
import zerolight.procedures.FurryProcedure2Procedure;
import zerolight.procedures.FurryProcedure3Procedure;
import zerolight.procedures.FurryProcedureProcedure;
import zerolight.procedures.FurrySpawnProcedureProcedure;

@ZerolightModElements.ModElement.Tag
public class FurryEntity
extends ZerolightModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 2.0f).func_206830_a("furry").setRegistryName("furry");

    public FurryEntity(ZerolightModElements instance) {
        super(instance, 78);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new FurryRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -1, -1, new Item.Properties().func_200916_a(ZeroLightTabItemGroup.tab)).setRegistryName("furry_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("zerolight:changeable_mountains").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("zerolight:magic_jungle").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("zerolight:magic_mountains").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("zerolight:magic_plain").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 10, 1, 1));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            return FurrySpawnProcedureProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, IServerWorld>("world", world), new AbstractMap.SimpleEntry<String, Integer>("x", x), new AbstractMap.SimpleEntry<String, Integer>("y", y), new AbstractMap.SimpleEntry<String, Integer>("z", z)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
        });
    }

    public static class CustomEntity
    extends CreatureEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{((Object)((Object)this)).getClass()}));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(6, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 0.6, false));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70645_a(DamageSource source) {
            super.func_70645_a(source);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Entity sourceentity = source.func_76346_g();
            CustomEntity entity = this;
            FurryProcedure3Procedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, World>("world", this.field_70170_p), new AbstractMap.SimpleEntry<String, Double>("x", x), new AbstractMap.SimpleEntry<String, Double>("y", y), new AbstractMap.SimpleEntry<String, Double>("z", z), new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
        }

        public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT tag) {
            ILivingEntityData retval = super.func_213386_a(world, difficulty, reason, livingdata, tag);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            FurryProcedureProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
            return retval;
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            FurryProcedure2Procedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, CustomEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 20.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 8.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

