/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.tile;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thetestmod.bettercrates.tile.CustomItemStackHandler;

public abstract class TileEntityBase
extends TileEntity {
    public CustomItemStackHandler inventory;
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);

    public TileEntityBase(TileEntityType<?> type, int size) {
        super(type);
        this.inventory = new CustomItemStackHandler(size);
    }

    public NonNullList<ItemStack> getInv() {
        return this.inventory.getStacks();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeRestorableToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readRestorableFromNBT(compound);
        super.func_230337_a_(state, compound);
    }

    public void readRestorableFromNBT(CompoundNBT compound) {
        CompoundNBT tag = compound.func_74775_l("inventory");
        this.inventory.deserializeNBT(tag);
    }

    public void writeRestorableToNBT(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return !this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(capability, facing);
    }

    public boolean stillValid(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }
}

