/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.tile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thetestmod.bettercrates.tile.CustomItemStackHandler;

public abstract class TileEntityBase
extends BlockEntity {
    public CustomItemStackHandler inventory;
    private LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);

    public TileEntityBase(BlockEntityType<?> type, int size, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new CustomItemStackHandler(size);
    }

    public NonNullList<ItemStack> getInv() {
        return this.inventory.getStacks();
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeRestorableToNBT(compound);
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.readRestorableFromNBT(compound);
        super.m_142466_(compound);
    }

    public void readRestorableFromNBT(CompoundTag compound) {
        CompoundTag tag = compound.m_128469_("inventory");
        this.inventory.deserializeNBT(tag);
    }

    public void writeRestorableToNBT(CompoundTag compound) {
        compound.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return !this.f_58859_ && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(capability, facing);
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void reviveCaps() {
        this.holder = LazyOptional.of(() -> this.inventory);
    }
}

