/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import thetestmod.bettercrates.container.ContainerBase13Rows;
import thetestmod.bettercrates.container.ContainerBase9Rows;
import thetestmod.bettercrates.enums.EnumCrate;
import thetestmod.bettercrates.tile.TileEntityBase;

public class BaseCrate
extends Block
implements EntityBlock {
    private final EnumCrate enumCrate;

    public BaseCrate(EnumCrate enumCrate) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, enumCrate.getResistance()));
        this.setRegistryName("bettercrates", enumCrate.getName());
        this.enumCrate = enumCrate;
        enumCrate.setBlock(this);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider(this.getContainerProvider(pos), (Component)new TranslatableComponent(this.enumCrate.getTransKey())), buf -> buf.m_130064_(pos).writeInt(this.enumCrate.ordinal()));
        return InteractionResult.CONSUME;
    }

    private MenuConstructor getContainerProvider(BlockPos pos) {
        if (this.enumCrate.ordinal() >= 5) {
            return (id, playerInv, player) -> new ContainerBase13Rows(id, playerInv, pos, this.enumCrate);
        }
        return (id, playerInv, player) -> new ContainerBase9Rows(id, playerInv, pos, this.enumCrate);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.enumCrate.getSupplier().m_155267_(blockPos, blockState);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity te = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (te instanceof TileEntityBase) {
            ItemStack stack = new ItemStack((ItemLike)Item.m_41439_((Block)this));
            CompoundTag tagCompound = new CompoundTag();
            ((TileEntityBase)te).writeRestorableToNBT(tagCompound);
            stack.m_41751_(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.m_7381_(state, builder);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (te = worldIn.m_7702_(pos)) instanceof TileEntityBase) {
            ((TileEntityBase)te).readRestorableFromNBT(tag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.crate_base.tooltip"));
    }
}

