/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import thetestmod.bettercrates.container.ContainerBase13Rows;
import thetestmod.bettercrates.container.ContainerBase9Rows;
import thetestmod.bettercrates.enums.EnumCrate;
import thetestmod.bettercrates.tile.TileEntityBase;

public class BaseCrate
extends Block {
    private final EnumCrate enumCrate;

    public BaseCrate(EnumCrate enumCrate) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, enumCrate.getResistance()));
        this.setRegistryName("bettercrates", enumCrate.getName());
        this.enumCrate = enumCrate;
        enumCrate.setBlock(this);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand p_220051_5_, BlockRayTraceResult p_220051_6_) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider(this.getContainerProvider(pos), (ITextComponent)new TranslationTextComponent(this.enumCrate.getTransKey(), new Object[0])), buf -> buf.func_179255_a(pos).writeInt(this.enumCrate.ordinal()));
        }
        return true;
    }

    private IContainerProvider getContainerProvider(BlockPos pos) {
        if (this.enumCrate.ordinal() >= 5) {
            return (id, playerInv, player) -> new ContainerBase13Rows(id, playerInv, pos, this.enumCrate);
        }
        return (id, playerInv, player) -> new ContainerBase9Rows(id, playerInv, pos, this.enumCrate);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.enumCrate.getSupplier().get();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof TileEntityBase) {
            ItemStack stack = new ItemStack((IItemProvider)Item.func_150898_a((Block)this));
            CompoundNBT tagCompound = new CompoundNBT();
            ((TileEntityBase)te).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.func_220076_a(state, builder);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te;
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (te = worldIn.func_175625_s(pos)) instanceof TileEntityBase) {
            ((TileEntityBase)te).readRestorableFromNBT(tag);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.crate_base.tooltip", new Object[0]));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

