/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagslib.block;

import ftblag.lagslib.events.LagsLibModEventHandler;
import ftblag.lagslib.interfaces.Function4x;
import ftblag.lagslib.tooltip.ToolTipBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class BaseBlock
extends Block {
    protected ItemGroup group;

    public BaseBlock(String modid, String name, ItemGroup group, Block.Properties properties) {
        super(properties);
        this.setRegistryName(modid, name);
        this.group = group;
        if (this.autoRegistry()) {
            LagsLibModEventHandler.BLOCKS.add(this);
        }
    }

    public BaseBlock(ResourceLocation name, ItemGroup group, Block.Properties properties) {
        super(properties);
        this.setRegistryName(name);
        LagsLibModEventHandler.BLOCKS.add(this);
        this.group = group;
    }

    public boolean autoRegistry() {
        return true;
    }

    public BlockItem getBlockItem() {
        BlockItem item = new BlockItem((Block)this, new Item.Properties().func_200916_a(this.group));
        item.setRegistryName(this.getRegistryName());
        return item;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addInformation(stack, ToolTipBuilder.of(tooltip), flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(ItemStack stack, ToolTipBuilder tooltip, ITooltipFlag flagIn) {
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.breakBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void breakBlock(World world, BlockPos pos) {
    }

    public void openGui(PlayerEntity player, Function4x<Integer, PlayerInventory, BlockPos, Container> supplier, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInv, p) -> (Container)supplier.apply(id, playerInv, pos), (ITextComponent)new StringTextComponent("inventory")), (BlockPos)pos);
    }

    public void openGui(PlayerEntity player, Function4x<Integer, PlayerInventory, BlockPos, Container> supplier, BlockPos pos, Consumer<PacketBuffer> consumer) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInv, p) -> (Container)supplier.apply(id, playerInv, pos), (ITextComponent)new StringTextComponent("inventory")), consumer.andThen(buf -> buf.func_179255_a(pos)));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        NonNullList ret = NonNullList.func_191196_a();
        Random rand = builder.func_216018_a().field_73012_v;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((ItemStack)builder.func_216019_b(LootParameters.field_216289_i)));
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.getItemDropped(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            ret.add((Object)new ItemStack((IItemProvider)item, 1));
        }
        return ret;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public Item getItemDropped(BlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int quantityDroppedWithBonus(int fortune, Random random) {
        return this.quantityDropped(random);
    }

    public int quantityDropped(BlockState state, int fortune, Random random) {
        return this.quantityDroppedWithBonus(fortune, random);
    }
}

