/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagslib.events;

import com.google.common.collect.Lists;
import ftblag.lagslib.LagsLib;
import ftblag.lagslib.block.BaseBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lagslib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LagsLibModEventHandler {
    public static final List<Item> ITEMS = Lists.newArrayList();
    public static final List<BaseBlock> BLOCKS = Lists.newArrayList();

    @SubscribeEvent
    public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
        BLOCKS.forEach(element -> {
            event.getRegistry().register((IForgeRegistryEntry)element);
            LagsLib.LOGGER.info("[Lag's Lib] Register {} block", (Object)element.getRegistryName());
        });
        LagsLib.LOGGER.info("[Lag's Lib] Finally registered {} blocks", (Object)BLOCKS.size());
    }

    @SubscribeEvent
    public static void onItemRegistry(RegistryEvent.Register<Item> event) {
        ITEMS.forEach(element -> {
            event.getRegistry().register((IForgeRegistryEntry)element);
            LagsLib.LOGGER.info("[Lag's Lib] Register {} items", (Object)element.getRegistryName());
        });
        LagsLib.LOGGER.info("[Lag's Lib] Finally registered {} item", (Object)ITEMS.size());
        BLOCKS.stream().map(BaseBlock::getBlockItem).forEach(element -> {
            event.getRegistry().register((IForgeRegistryEntry)element);
            LagsLib.LOGGER.info("[Lag's Lib] Register {} item block", (Object)element.getRegistryName());
        });
        LagsLib.LOGGER.info("[Lag's Lib] Finally registered {} item blocks", (Object)BLOCKS.size());
        ITEMS.clear();
        BLOCKS.clear();
    }
}

