/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagslib.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import ftblag.lagslib.LagsLib;
import ftblag.lagslib.interfaces.ICookingFactory;
import ftblag.lagslib.recipe.CustomRecipe;
import ftblag.lagslib.utils.IngredientUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeBuilder {
    protected String modid;
    protected List<CustomRecipe> recipes = new ArrayList<CustomRecipe>();
    protected List<Pair<Map<Character, Ingredient>, String[]>> groups = new ArrayList<Pair<Map<Character, Ingredient>, String[]>>();
    protected Map<String, Pair<Map<Character, Ingredient>, String[]>> namedGroups = new HashMap<String, Pair<Map<Character, Ingredient>, String[]>>();
    protected boolean started;
    protected String name;
    protected boolean invalidRecipe;

    protected RecipeBuilder(@Nonnull String modid) {
        this.modid = modid;
        this.groups.add((Pair<Map<Character, Ingredient>, String[]>)MutablePair.of((Object)Maps.newHashMap(), null));
    }

    public static RecipeBuilder of(@Nonnull String modid) {
        return new RecipeBuilder(modid);
    }

    public void register(List<CustomRecipe> list) {
        list.addAll(this.recipes);
        this.recipes.clear();
    }

    public RecipeBuilder createGroup() {
        this.groups.add((Pair<Map<Character, Ingredient>, String[]>)MutablePair.of((Object)Maps.newHashMap((Map)((Map)this.getLast().getKey())), (Object)this.getLast().getRight()));
        return this;
    }

    public RecipeBuilder endGroup() {
        if (this.groups.size() == 1) {
            throw new RuntimeException("Cant remove default group");
        }
        this.groups.remove(this.groups.size() - 1);
        return this;
    }

    public RecipeBuilder groupKey(@Nonnull Character chr, @Nonnull Object in) {
        Ingredient ing = IngredientUtils.getIngredient(in);
        if (ing == null) {
            this.invalidRecipe = true;
        }
        if (ing == Ingredient.field_193370_a) {
            LagsLib.LOGGER.warn("[Lag's Lib] Not found ingredient for: {}!", in);
        }
        ((Map)this.getLast().getLeft()).put(chr, ing);
        return this;
    }

    public RecipeBuilder removeGroupKey(@Nonnull Character chr) {
        ((Map)this.getLast().getLeft()).remove(chr);
        return this;
    }

    public RecipeBuilder groupPattern(String ... pattern) {
        this.getLast().setValue((Object)pattern);
        return this;
    }

    protected Pair<Map<Character, Ingredient>, String[]> getLast() {
        return this.groups.get(this.groups.size() - 1);
    }

    public RecipeBuilder namedGroupKey(@Nonnull String groupName, @Nonnull Character chr, @Nonnull Object in) {
        Ingredient ing = IngredientUtils.getIngredient(in);
        if (ing == null) {
            this.invalidRecipe = true;
        }
        if (ing == Ingredient.field_193370_a) {
            LagsLib.LOGGER.warn("[Lag's Lib] Not found ingredient for: {}!", in);
        }
        ((Map)this.getNamedGroup(groupName).getLeft()).put(chr, ing);
        return this;
    }

    public RecipeBuilder removeNamedGroupKey(@Nonnull String groupName, @Nonnull Character chr) {
        ((Map)this.getNamedGroup(groupName).getLeft()).remove(chr);
        return this;
    }

    public RecipeBuilder namedGroupPattern(@Nonnull String groupName, String ... pattern) {
        this.getNamedGroup(groupName).setValue((Object)pattern);
        return this;
    }

    protected Pair<Map<Character, Ingredient>, String[]> getNamedGroup(@Nonnull String groupName) {
        if (!this.namedGroups.containsKey(groupName)) {
            this.namedGroups.put(groupName, (Pair<Map<Character, Ingredient>, String[]>)MutablePair.of((Object)Maps.newHashMap(), null));
        }
        return this.namedGroups.get(groupName);
    }

    protected ResourceLocation getName() {
        if (this.name == null) {
            throw new RuntimeException("Cant make registryName because name is null");
        }
        return new ResourceLocation(this.modid, this.name);
    }

    protected void resetConstants() {
        this.started = false;
        this.name = null;
        this.invalidRecipe = false;
    }

    protected void next(@Nonnull String name) {
        if (this.started) {
            throw new RuntimeException("Cant start new recipe if previous not finished");
        }
        this.started = true;
        this.name = name;
    }

    public ShapedRecipeBuilder nextShaped(@Nonnull String name) {
        this.next(name);
        return new ShapedRecipeBuilder();
    }

    public ShapelessRecipeBuilder nextShapeless(@Nonnull String name) {
        this.next(name);
        return new ShapelessRecipeBuilder();
    }

    public StonecuttingRecipeBuilder nextStonecutting(@Nonnull String name) {
        this.next(name);
        return new StonecuttingRecipeBuilder();
    }

    public CookingRecipeBuilder<FurnaceRecipe> nextFurnace(@Nonnull String name) {
        this.next(name);
        return new CookingRecipeBuilder<FurnaceRecipe>(FurnaceRecipe::new, 200);
    }

    public CookingRecipeBuilder<BlastingRecipe> nextBlasting(@Nonnull String name) {
        this.next(name);
        return new CookingRecipeBuilder<BlastingRecipe>(BlastingRecipe::new, 100);
    }

    public CookingRecipeBuilder<SmokingRecipe> nextSmoking(@Nonnull String name) {
        this.next(name);
        return new CookingRecipeBuilder<SmokingRecipe>(SmokingRecipe::new, 100);
    }

    public CookingRecipeBuilder<CampfireCookingRecipe> nextCampfire(@Nonnull String name) {
        this.next(name);
        return new CookingRecipeBuilder<CampfireCookingRecipe>(CampfireCookingRecipe::new, 100);
    }

    public class CookingRecipeBuilder<T extends AbstractCookingRecipe>
    extends BaseSingleIngredientRecipeBuilder<CookingRecipeBuilder<T>> {
        protected float experience;
        protected int cookTime;
        protected final ICookingFactory<T> factory;

        public CookingRecipeBuilder(ICookingFactory<T> factory, int defaultCookTime) {
            this.factory = factory;
            this.cookTime = defaultCookTime;
        }

        public CookingRecipeBuilder experience(float experience) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set experience if recipe not started");
            }
            this.experience = experience;
            return this;
        }

        public CookingRecipeBuilder cookTime(int cookTime) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set cookTime if recipe not started");
            }
            this.cookTime = cookTime;
            return this;
        }

        public RecipeBuilder build() {
            RecipeBuilder.this.recipes.add(this.buildRecipe());
            RecipeBuilder.this.resetConstants();
            return RecipeBuilder.this;
        }

        public CustomRecipe buildRecipe() {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant build recipe if recipe not started");
            }
            if (this.output.func_190926_b()) {
                throw new RuntimeException("Output not defined for recipe");
            }
            if (this.ingredients.size() == 0) {
                throw new RuntimeException("Ingredient not defined for recipe");
            }
            if (RecipeBuilder.this.invalidRecipe) {
                return CustomRecipe.of(null);
            }
            return CustomRecipe.of(this.factory.create(RecipeBuilder.this.getName(), this.group, (Ingredient)this.ingredients.get(0), this.output, this.experience, this.cookTime));
        }
    }

    public class StonecuttingRecipeBuilder
    extends BaseSingleIngredientRecipeBuilder<StonecuttingRecipeBuilder> {
        public RecipeBuilder build() {
            RecipeBuilder.this.recipes.add(this.buildRecipe());
            RecipeBuilder.this.resetConstants();
            return RecipeBuilder.this;
        }

        public CustomRecipe buildRecipe() {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant build recipe if recipe not started");
            }
            if (this.output.func_190926_b()) {
                throw new RuntimeException("Output not defined for recipe");
            }
            if (this.ingredients.size() == 0) {
                throw new RuntimeException("Ingredient not defined for recipe");
            }
            if (RecipeBuilder.this.invalidRecipe) {
                return CustomRecipe.of(null);
            }
            return CustomRecipe.of(new StonecuttingRecipe(RecipeBuilder.this.getName(), this.group, (Ingredient)this.ingredients.get(0), this.output));
        }
    }

    public class ShapelessRecipeBuilder
    extends BaseIngredientRecipeBuilder<ShapelessRecipeBuilder> {
        public RecipeBuilder build() {
            RecipeBuilder.this.recipes.add(this.buildRecipe());
            RecipeBuilder.this.resetConstants();
            return RecipeBuilder.this;
        }

        public CustomRecipe buildRecipe() {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant build recipe if recipe not started");
            }
            if (this.output.func_190926_b()) {
                throw new RuntimeException("Output not defined for recipe");
            }
            if (this.ingredients.size() == 0) {
                throw new RuntimeException("Ingredients not defined for recipe");
            }
            if (RecipeBuilder.this.invalidRecipe) {
                return CustomRecipe.of(null);
            }
            return CustomRecipe.of(new ShapelessRecipe(RecipeBuilder.this.getName(), this.group, this.output, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])this.ingredients.toArray(new Ingredient[0]))));
        }
    }

    public class ShapedRecipeBuilder
    extends BaseRecipeBuilder<ShapedRecipeBuilder> {
        protected final Map<Character, Ingredient> keys;
        protected String[] pattern;
        protected String groupName;

        public ShapedRecipeBuilder() {
            this.keys = Maps.newHashMap();
        }

        public ShapedRecipeBuilder useNamedGroup(@Nonnull String groupName) {
            this.groupName = groupName;
            return this;
        }

        public ShapedRecipeBuilder oldStyle(Object ... recipe) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set output if recipe not started");
            }
            ArrayList pattern = Lists.newArrayList();
            int index = 0;
            for (Object obj : recipe) {
                if (!(obj instanceof String)) break;
                pattern.add((String)obj);
                ++index;
            }
            while (index < recipe.length) {
                this.key((Character)recipe[index], recipe[index + 1]);
                index += 2;
            }
            this.pattern(pattern.toArray(new String[0]));
            return this;
        }

        public ShapedRecipeBuilder key(@Nonnull Character chr, @Nonnull Object in) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant add key if recipe not started");
            }
            Ingredient ing = IngredientUtils.getIngredient(in);
            if (ing == null) {
                RecipeBuilder.this.invalidRecipe = true;
            }
            if (ing == Ingredient.field_193370_a) {
                LagsLib.LOGGER.warn("[Lag's Lib] Not found ingredient for: {}!", in);
            }
            this.keys.put(chr, ing);
            return this;
        }

        public ShapedRecipeBuilder keys(Object ... keys) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set output if recipe not started");
            }
            for (int index = 0; index < keys.length; index += 2) {
                this.key((Character)keys[index], keys[index + 1]);
            }
            return this;
        }

        public ShapedRecipeBuilder pattern(String ... pattern) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set pattern if recipe not started");
            }
            int len = pattern[0].length();
            for (String s : pattern) {
                if (len == s.length()) continue;
                throw new RuntimeException("Wrong width for pattern");
            }
            this.pattern = pattern;
            return this;
        }

        public RecipeBuilder build() {
            RecipeBuilder.this.recipes.add(this.buildRecipe());
            RecipeBuilder.this.resetConstants();
            return RecipeBuilder.this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CustomRecipe buildRecipe() {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant build recipe if recipe not started");
            }
            if (this.pattern == null) {
                if (this.groupName != null) {
                    if (!RecipeBuilder.this.namedGroups.containsKey(this.groupName)) throw new RuntimeException("Used group with name \"" + this.groupName + "\" but group not found!");
                    this.pattern = (String[])RecipeBuilder.this.namedGroups.get(this.groupName).getRight();
                } else {
                    this.pattern = (String[])RecipeBuilder.this.getLast().getRight();
                }
                if (this.pattern == null) {
                    throw new RuntimeException("Pattern not defined for recipe");
                }
            }
            if (this.output.func_190926_b()) {
                throw new RuntimeException("Output not defined for recipe");
            }
            if (RecipeBuilder.this.invalidRecipe) {
                return CustomRecipe.of(null);
            }
            int width = this.pattern[0].length();
            int height = this.pattern.length;
            int size = 0;
            for (String s : this.pattern) {
                size += s.length();
            }
            if (width * height != size) {
                throw new RuntimeException("Invalid recipe, width * height pattern != pattern size");
            }
            NonNullList input = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            int index = -1;
            for (String s : this.pattern) {
                for (char chr : s.toCharArray()) {
                    ++index;
                    if (chr == ' ') continue;
                    Ingredient ing = this.keys.get(Character.valueOf(chr));
                    if (ing == null) {
                        if (this.groupName != null) {
                            if (!RecipeBuilder.this.namedGroups.containsKey(this.groupName)) throw new RuntimeException("Used group with name \"" + this.groupName + "\" but group not found!");
                            this.pattern = (String[])RecipeBuilder.this.namedGroups.get(this.groupName).getRight();
                        } else {
                            ing = (Ingredient)((Map)RecipeBuilder.this.getLast().getKey()).get(Character.valueOf(chr));
                        }
                        if (ing == null) {
                            throw new RuntimeException("Symbol '" + chr + "' not defined");
                        }
                    }
                    input.set(index, (Object)ing);
                }
            }
            return CustomRecipe.of(new ShapedRecipe(RecipeBuilder.this.getName(), this.group, width, height, input, this.output));
        }
    }

    public class BaseIngredientRecipeBuilder<T extends BaseIngredientRecipeBuilder<T>>
    extends BaseRecipeBuilder<T> {
        protected List<Ingredient> ingredients;

        public BaseIngredientRecipeBuilder() {
            this.ingredients = Lists.newArrayList();
        }

        public T ingredientList(@Nonnull NonNullList<?> in) {
            for (Object o : in) {
                this.ingredient(o);
            }
            return (T)this;
        }

        public T ingredients(Object ... in) {
            for (Object o : in) {
                this.ingredient(o);
            }
            return (T)this;
        }

        public T ingredient(@Nonnull Object in) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant add ingredient if recipe not started");
            }
            Ingredient ing = IngredientUtils.getIngredient(in);
            if (ing == null) {
                RecipeBuilder.this.invalidRecipe = true;
            }
            if (ing == Ingredient.field_193370_a) {
                LagsLib.LOGGER.warn("[Lag's Lib] Not found ingredient for: {}!", in);
            }
            this.ingredients.add(ing);
            return (T)this;
        }
    }

    public class BaseSingleIngredientRecipeBuilder<T extends BaseSingleIngredientRecipeBuilder<T>>
    extends BaseRecipeBuilder<T> {
        protected List<Ingredient> ingredients;

        public BaseSingleIngredientRecipeBuilder() {
            this.ingredients = Lists.newArrayList();
        }

        public T ingredient(@Nonnull Object in) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant add ingredient if recipe not started");
            }
            Ingredient ing = IngredientUtils.getIngredient(in);
            if (ing == null) {
                RecipeBuilder.this.invalidRecipe = true;
            }
            if (ing == Ingredient.field_193370_a) {
                LagsLib.LOGGER.warn("[Lag's Lib] Not found ingredient for: {}!", in);
            }
            this.ingredients.set(0, ing);
            return (T)this;
        }
    }

    public class BaseRecipeBuilder<T extends BaseRecipeBuilder<T>> {
        protected String group = "";
        protected ItemStack output = ItemStack.field_190927_a;

        public T group(ResourceLocation group) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set group if recipe not started");
            }
            if (group != null) {
                this.group = group.toString();
            }
            return (T)this;
        }

        public T output(@Nonnull IItemProvider provider) {
            return this.output(new ItemStack(provider));
        }

        public T output(@Nonnull IItemProvider provider, int count) {
            return this.output(new ItemStack(provider, count));
        }

        public T output(@Nonnull ItemStack stack) {
            if (!RecipeBuilder.this.started) {
                throw new RuntimeException("Cant set output if recipe not started");
            }
            this.output = stack.func_77946_l();
            return (T)this;
        }
    }
}

