/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagslib.registry;

import com.google.common.collect.Lists;
import com.mojang.datafixers.types.Type;
import ftblag.lagslib.LagsLib;
import ftblag.lagslib.events.LagsLibModEventHandler;
import ftblag.lagslib.interfaces.IScreenFactoryCommon;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryData {
    private final List<ContainerType<?>> CONTAINERS = Lists.newArrayList();
    private final List<TileEntityType<?>> TILES = Lists.newArrayList();
    private final List<EntityType<?>> ENTITES = Lists.newArrayList();
    private final String modid;

    public RegistryData(String modid) {
        this.modid = modid;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addGenericListener(ContainerType.class, this::onContainerRegistry);
        modBus.addGenericListener(TileEntityType.class, this::onTileRegistry);
        modBus.addGenericListener(EntityType.class, this::onEntityRegistry);
    }

    private void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
        this.CONTAINERS.forEach(element -> {
            event.getRegistry().register((IForgeRegistryEntry)element);
            LagsLib.LOGGER.info("[Lag's Lib] Register {} container type for {}", (Object)element.getRegistryName(), (Object)this.modid);
        });
        LagsLib.LOGGER.info("[Lag's Lib] Finally registered {} container types for {}", (Object)this.CONTAINERS.size(), (Object)this.modid);
        this.CONTAINERS.clear();
    }

    private void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
        this.TILES.forEach(element -> {
            event.getRegistry().register((IForgeRegistryEntry)element);
            LagsLib.LOGGER.info("[Lag's Lib] Register {} tile type for {}", (Object)element.getRegistryName(), (Object)this.modid);
        });
        LagsLib.LOGGER.info("[Lag's Lib] Finally registered {} tile types for {}", (Object)this.TILES.size(), (Object)this.modid);
        this.TILES.clear();
    }

    private void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
        this.ENTITES.forEach(element -> {
            event.getRegistry().register((IForgeRegistryEntry)element);
            LagsLib.LOGGER.info("[Lag's Lib] Register {} entity type for {}", (Object)element.getRegistryName(), (Object)this.modid);
        });
        LagsLib.LOGGER.info("[Lag's Lib] Finally registered {} entity types for {}", (Object)this.ENTITES.size(), (Object)this.modid);
        this.ENTITES.clear();
    }

    public <T extends Container, U extends Screen> ContainerTypeBuilder<T, U> container(IContainerFactory<T> factory) {
        return new ContainerTypeBuilder(factory);
    }

    public <T extends TileEntity> TileEntityTypeBuilder<T> tile(Supplier<? extends T> factory, Block ... valid) {
        return new TileEntityTypeBuilder<T>(factory, valid);
    }

    public <T extends Entity> EntityTypeBuilder<T> entity(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height) {
        return new EntityTypeBuilder<T>(factory, classification, width, height);
    }

    public class EntityTypeBuilder<T extends Entity> {
        private EntityType.Builder<T> builder;
        private boolean hasEgg;
        private int eggPrimary;
        private int eggSecondary;
        private ResourceLocation lootTable;
        private Supplier<IRenderFactory<T>> supplier;

        public EntityTypeBuilder(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height) {
            this.builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification).func_220321_a(width, height);
        }

        public EntityTypeBuilder<T> track(int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.builder.setTrackingRange(trackingRange).setUpdateInterval(updateFrequency).setShouldReceiveVelocityUpdates(sendsVelocityUpdates);
            return this;
        }

        public EntityTypeBuilder<T> consumer(Consumer<EntityType.Builder<T>> consumer) {
            consumer.accept(this.builder);
            return this;
        }

        public EntityTypeBuilder<T> render(Supplier<IRenderFactory<T>> supplier) {
            if (EffectiveSide.get().isClient()) {
                this.supplier = supplier;
            }
            return this;
        }

        public EntityTypeBuilder<T> egg(int eggPrimary, int eggSecondary) {
            this.hasEgg = true;
            this.eggPrimary = eggPrimary;
            this.eggSecondary = eggSecondary;
            return this;
        }

        public EntityTypeBuilder<T> lootFrom(EntityType<?> type) {
            this.lootTable = type.func_220348_g();
            return this;
        }

        public EntityTypeBuilder<T> lootFrom(ResourceLocation lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public EntityType<T> build(String name) {
            EntityType type = this.builder.func_206830_a(RegistryData.this.modid + ":" + name);
            type.setRegistryName(RegistryData.this.modid, name);
            RegistryData.this.ENTITES.add(type);
            if (this.hasEgg) {
                SpawnEggItem egg = new SpawnEggItem(type, this.eggPrimary, this.eggSecondary, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
                egg.setRegistryName(RegistryData.this.modid, name + "_spawn_egg");
                LagsLibModEventHandler.ITEMS.add((Item)egg);
            }
            if (this.lootTable != null) {
                type.field_220358_bg = this.lootTable;
            }
            if (this.supplier != null) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)type, this.supplier.get());
            }
            return type;
        }
    }

    public class TileEntityTypeBuilder<T extends TileEntity> {
        private TileEntityType.Builder<T> builder;
        private Type<?> datafixerType;
        private Supplier<Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super T>>> supplier;

        public TileEntityTypeBuilder(Supplier<? extends T> factory, Block ... valid) {
            this.builder = TileEntityType.Builder.func_223042_a(factory, (Block[])valid);
        }

        public TileEntityTypeBuilder<T> dataFixer(Type<?> datafixerType) {
            this.datafixerType = datafixerType;
            return this;
        }

        public TileEntityTypeBuilder<T> render(Supplier<Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super T>>> supplier) {
            if (EffectiveSide.get().isClient()) {
                this.supplier = supplier;
            }
            return this;
        }

        public TileEntityType<T> build(String name) {
            TileEntityType type = this.builder.func_206865_a(this.datafixerType);
            type.setRegistryName(RegistryData.this.modid, name);
            if (this.supplier != null) {
                ClientRegistry.bindTileEntityRenderer((TileEntityType)type, this.supplier.get());
            }
            RegistryData.this.TILES.add(type);
            return type;
        }
    }

    public class ContainerTypeBuilder<T extends Container, U extends Screen> {
        private ContainerType<T> type;
        private Supplier<IScreenFactoryCommon<T, U>> supplier;

        public ContainerTypeBuilder(IContainerFactory<T> factory) {
            this.type = IForgeContainerType.create(factory);
        }

        public ContainerTypeBuilder<T, U> gui(Supplier<IScreenFactoryCommon<T, U>> supplier) {
            if (EffectiveSide.get().isClient()) {
                this.supplier = supplier;
            }
            return this;
        }

        public ContainerType<T> build(String name) {
            this.type.setRegistryName(RegistryData.this.modid, name);
            RegistryData.this.CONTAINERS.add(this.type);
            if (EffectiveSide.get().isClient() && this.supplier != null) {
                ScreenManager.func_216911_a(this.type, this.supplier.get()::create);
            }
            return this.type;
        }
    }
}

