/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagslib.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import ftblag.lagslib.events.CustomTagsEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class TagsBuilder {
    protected final NetworkTagManager manager;

    private TagsBuilder(NetworkTagManager manager) {
        this.manager = manager;
    }

    public static TagsBuilder of(CustomTagsEvent event) {
        return new TagsBuilder(event.getTagManager());
    }

    public static TagsBuilder of(NetworkTagManager manager) {
        return new TagsBuilder(manager);
    }

    public BaseTagsBuilder<Block> nextBlock(@Nonnull String modid, @Nonnull String name) {
        return new BaseTagsBuilder<Block>(this.manager.func_199717_a().func_200039_c(), new ResourceLocation(modid, name));
    }

    public BaseTagsBuilder<Item> nextItem(@Nonnull String modid, @Nonnull String name) {
        return new BaseTagsBuilder<Item>(this.manager.func_199715_b().func_200039_c(), new ResourceLocation(modid, name));
    }

    public BaseTagsBuilder<Fluid> nextFluid(@Nonnull String modid, @Nonnull String name) {
        return new BaseTagsBuilder<Fluid>(this.manager.func_205704_c().func_200039_c(), new ResourceLocation(modid, name));
    }

    public BaseTagsBuilder<EntityType<?>> nextEntityType(@Nonnull String modid, @Nonnull String name) {
        return new BaseTagsBuilder(this.manager.func_215297_d().func_200039_c(), new ResourceLocation(modid, name));
    }

    public class BaseTagsBuilder<T> {
        protected final Tag<T> tag;

        public BaseTagsBuilder(Map<ResourceLocation, Tag<T>> map, ResourceLocation name) {
            if (!map.containsKey(name)) {
                map.put(name, new Tag(name, (Collection)Sets.newLinkedHashSet(), false));
            }
            this.tag = map.get(name);
        }

        public BaseTagsBuilder<T> add(Tag.ITagEntry<T> entry) {
            this.tag.func_200570_b().add(entry);
            entry.func_200162_a(this.tag.func_199885_a());
            return this;
        }

        public BaseTagsBuilder<T> add(T itemIn) {
            this.add((T)new Tag.ListEntry(Collections.singleton(itemIn)));
            return this;
        }

        @SafeVarargs
        public final BaseTagsBuilder<T> add(T ... itemsIn) {
            this.add((T)new Tag.ListEntry((Collection)Lists.newArrayList((Object[])itemsIn)));
            return this;
        }

        public BaseTagsBuilder<T> add(Tag<T> tagIn) {
            this.add((T)new Tag.TagEntry(tagIn));
            return this;
        }

        @SafeVarargs
        public final BaseTagsBuilder<T> add(Tag<T> ... tags) {
            for (Tag<T> tag : tags) {
                this.add(tag);
            }
            return this;
        }

        public BaseTagsBuilder<T> remove(Tag.ITagEntry<T> entry) {
            this.tag.func_200570_b().remove(entry);
            LinkedHashSet set = Sets.newLinkedHashSet();
            entry.func_200162_a((Collection)set);
            this.tag.func_199885_a().removeAll(set);
            return this;
        }

        public TagsBuilder done() {
            return TagsBuilder.this;
        }
    }
}

