/*
 * Decompiled with CFR 0.152.
 */
package ftblag.lagslib.utils;

import com.google.common.collect.Maps;
import ftblag.lagslib.LagsLib;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class IngredientUtils {
    private static final Map<String, ResourceLocation> oldToNew = Maps.newHashMap();
    private static final Map<Class<?>, Function<Object, Ingredient>> ingredientParsers = Maps.newHashMap();

    private IngredientUtils() {
    }

    public static void addOldToNew(String oldName, ResourceLocation newName) {
        oldToNew.put(oldName, newName);
    }

    public static void addIngredientParser(Class<?> clazz, Function<Object, Ingredient> function) {
        ingredientParsers.put(clazz, function);
    }

    public static Ingredient getIngredient(Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)obj).func_77946_l()});
        }
        if (obj instanceof IItemProvider) {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)obj});
        }
        if (obj instanceof Tag) {
            return Ingredient.func_199805_a((Tag)((Tag)obj));
        }
        if (obj instanceof String) {
            ResourceLocation res;
            String in = (String)obj;
            if (in.startsWith("tag:")) {
                res = new ResourceLocation(in.substring(4));
            } else if (oldToNew.containsKey(in)) {
                res = oldToNew.get(in);
            } else {
                String modid;
                int doth = in.indexOf(":");
                if (doth != -1) {
                    modid = in.substring(0, doth);
                    in = in.substring(doth + 1);
                } else {
                    modid = "forge";
                }
                int index = 0;
                char lowerCase = '\u0000';
                for (char chr : in.toCharArray()) {
                    if (Character.isUpperCase(chr)) {
                        lowerCase = Character.toLowerCase(chr);
                        break;
                    }
                    ++index;
                }
                if (lowerCase != '\u0000') {
                    String path = in.substring(0, index);
                    if (path.equals("block")) {
                        path = "storage_block";
                    }
                    res = new ResourceLocation(modid, String.format("%ss/%s%s", path, Character.valueOf(lowerCase), in.substring(index + 1)));
                } else {
                    res = new ResourceLocation(modid, in);
                }
            }
            Tag tag = ItemTags.func_199903_a().func_199910_a(res);
            if (tag == null) {
                LagsLib.LOGGER.warn("[Lag's Lib] Not found ingredient for: {}!", obj);
                return null;
            }
            return Ingredient.func_199805_a((Tag)tag);
        }
        if (ingredientParsers.containsKey(obj.getClass())) {
            try {
                return ingredientParsers.get(obj.getClass()).apply(obj);
            }
            catch (Exception ex) {
                LagsLib.LOGGER.error("Failed to parse ingredient from custom parser! Object: {}", obj, (Object)ex);
                return null;
            }
        }
        throw new RuntimeException("Class " + obj.getClass() + " not implemented");
    }

    static {
        oldToNew.put("stickWood", new ResourceLocation("forge", "rods/wooden"));
        oldToNew.put("plankWood", new ResourceLocation("planks"));
        oldToNew.put("blockGlass", new ResourceLocation("forge", "glass"));
    }
}

