/*
 * Decompiled with CFR 0.152.
 */
package thetestmod.bettercrates;

import ftblag.lagslib.events.CustomRecipeEvent;
import ftblag.lagslib.recipe.RecipeBuilder;
import ftblag.lagslib.registry.RegistryData;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thetestmod.bettercrates.BetterCrates;
import thetestmod.bettercrates.container.ContainerBase13Rows;
import thetestmod.bettercrates.container.ContainerBase9Rows;
import thetestmod.bettercrates.enums.EnumCrate;
import thetestmod.bettercrates.gui.GuiBase13Rows;
import thetestmod.bettercrates.gui.GuiBase9Rows;
import thetestmod.bettercrates.init.BlocksRegistry;
import thetestmod.bettercrates.init.ItemsRegistry;

public class BCEventHandler {
    public static final ContainerType<ContainerBase9Rows> CONTAINER_9_ROWS;
    public static final ContainerType<ContainerBase13Rows> CONTAINER_13_ROWS;

    public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
        for (EnumCrate crate : EnumCrate.VALUES) {
            event.getRegistry().register((IForgeRegistryEntry)crate.getBlock());
        }
    }

    public static void onItemRegistry(RegistryEvent.Register<Item> event) {
        for (EnumCrate crate : EnumCrate.VALUES) {
            event.getRegistry().register(new BlockItem(crate.getBlock(), new Item.Properties().func_200916_a(BetterCrates.GROUP)).setRegistryName(crate.getBlock().getRegistryName()));
        }
    }

    public static void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
        for (EnumCrate crate : EnumCrate.VALUES) {
            event.getRegistry().register(crate.getType().setRegistryName("bettercrates", crate.getName()));
        }
    }

    public static void onRecipeRegistry(CustomRecipeEvent event) {
        RecipeBuilder builder = RecipeBuilder.of((String)"bettercrates");
        builder.groupPattern(new String[]{"SIS", "I I", "SIS"}).groupKey(Character.valueOf('I'), (Object)"tag:planks");
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("copper_crate").output((IItemProvider)BlocksRegistry.COPPER_CRATE)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/copper").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("diamond_crate").output((IItemProvider)BlocksRegistry.DIAMOND_CRATE)).key(Character.valueOf('S'), (Object)"tag:forge:gems/diamond").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("golden_crate").output((IItemProvider)BlocksRegistry.GOLDEN_CRATE)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/gold").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("iron_crate").output((IItemProvider)BlocksRegistry.IRON_CRATE)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/iron").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("obsidian_crate").output((IItemProvider)BlocksRegistry.OBSIDIAN_CRATE)).key(Character.valueOf('S'), (Object)"tag:forge:obsidian").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("tin_crate").output((IItemProvider)BlocksRegistry.TIN_CRATE)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/tin").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("wooden_crate").output((IItemProvider)BlocksRegistry.WOODEN_CRATE)).key(Character.valueOf('S'), (Object)"tag:logs").build();
        builder.groupPattern(new String[]{"SIS", "ITI", "SIS"}).groupKey(Character.valueOf('T'), (Object)"tag:signs");
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_copper").output((IItemProvider)ItemsRegistry.UP_COPPER)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/copper").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_diamond").output((IItemProvider)ItemsRegistry.UP_DIAMOND)).key(Character.valueOf('S'), (Object)"tag:forge:gems/diamond").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_golden").output((IItemProvider)ItemsRegistry.UP_GOLDEN)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/gold").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_golden2").output((IItemProvider)ItemsRegistry.UP_GOLDEN2)).key(Character.valueOf('T'), (Object)"tag:forge:ingots/copper").key(Character.valueOf('S'), (Object)"tag:forge:ingots/gold").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_golden3").output((IItemProvider)ItemsRegistry.UP_GOLDEN3)).key(Character.valueOf('T'), (Object)"tag:forge:ingots/tin").key(Character.valueOf('S'), (Object)"tag:forge:ingots/gold").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_iron").output((IItemProvider)ItemsRegistry.UP_IRON)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/iron").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_obsidian").output((IItemProvider)ItemsRegistry.UP_OBSIDIAN)).key(Character.valueOf('S'), (Object)"tag:forge:obsidian").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_tin").output((IItemProvider)ItemsRegistry.UP_TIN)).key(Character.valueOf('S'), (Object)"tag:forge:ingots/tin").build();
        ((RecipeBuilder.ShapedRecipeBuilder)builder.nextShaped("up_wooden_crate").output((IItemProvider)ItemsRegistry.UP_WOODEN)).key(Character.valueOf('S'), (Object)"tag:logs").build();
        event.register(builder);
    }

    static {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addGenericListener(Block.class, BCEventHandler::onBlockRegistry);
        modBus.addGenericListener(Item.class, BCEventHandler::onItemRegistry);
        modBus.addGenericListener(TileEntityType.class, BCEventHandler::onTileRegistry);
        MinecraftForge.EVENT_BUS.addListener(BCEventHandler::onRecipeRegistry);
        RegistryData data = new RegistryData("bettercrates");
        CONTAINER_9_ROWS = data.container(ContainerBase9Rows::new).gui(() -> GuiBase9Rows::new).build("container9rows");
        CONTAINER_13_ROWS = data.container(ContainerBase13Rows::new).gui(() -> GuiBase13Rows::new).build("container13rows");
    }
}

