/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;

public interface ICommand {
    public static final int OP_PERM_LEVEL = 4;

    default public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)ICommand.newLiteral(this.getName()).executes(this::checkPreConditionAndExecute);
    }

    public static LiteralArgumentBuilder<CommandSource> newLiteral(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<CommandSource, T> newArgument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    default public int checkPreConditionAndExecute(CommandContext<CommandSource> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.onExecute(context);
    }

    default public ICommandCallbackBuilder<CommandSource> executePreConditionCheck() {
        return executeCallback -> context -> {
            if (!this.checkPreCondition((CommandContext<CommandSource>)context)) {
                return 0;
            }
            return executeCallback.run(context);
        };
    }

    default public boolean checkPreCondition(CommandContext<CommandSource> context) {
        return ((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity || ((CommandSource)context.getSource()).func_197034_c(4);
    }

    public int onExecute(CommandContext<CommandSource> var1);

    public String getName();

    public static interface ICommandCallbackBuilder<S> {
        public Command<S> then(Command<CommandSource> var1);
    }
}

