/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.world.PostStructureInfoGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BossSpawnHandler {
    public static void onChestPlaced(IServerWorld world, LockableLootTileEntity chest) {
        List possibleBosses = (List)BossTypeManager.instance.lootTableSpawnEntries.get((Object)chest.field_184284_m);
        if (possibleBosses != null && !possibleBosses.isEmpty()) {
            if (BrutalBosses.rand.nextInt(100) > (Integer)BrutalBosses.config.getCommonConfig().globalBossSpawnChance.get()) {
                return;
            }
            BossType bossType = (BossType)possibleBosses.get(BrutalBosses.rand.nextInt(possibleBosses.size()));
            if (bossType.getID().func_110623_a().equals("dummyboss")) {
                return;
            }
            BossSpawnHandler.spawnBoss(world, chest.func_174877_v(), bossType, chest);
        } else if (((Boolean)BrutalBosses.config.getCommonConfig().printChestLoottable.get()).booleanValue()) {
            BrutalBosses.LOGGER.info("Chest with Loottable: " + chest.field_184284_m + " not associated with any boss spawn");
        }
    }

    public static void spawnBoss(IServerWorld world, BlockPos pos, BossType bossType, @Nullable LockableLootTileEntity chest) {
        BlockPos spawnPos;
        MobEntity boss = bossType.createBossEntity((World)world.func_201672_e());
        if (boss == null) {
            return;
        }
        if (chest != null) {
            String structname = "unkown structure";
            if (world instanceof PostStructureInfoGetter && ((PostStructureInfoGetter)world).getStructure() != null) {
                structname = ((PostStructureInfoGetter)world).getStructure().func_143025_a();
            }
            ResourceLocation lootTable = chest.field_184284_m;
            BrutalBosses.LOGGER.debug("Spawning " + bossType.getID() + " at " + pos + " at " + chest.func_145748_c_().getString() + " with:" + lootTable + " in " + structname);
        }
        if ((spawnPos = BossSpawnHandler.findSpawnPosForBoss(world, (Entity)boss, pos)) == null) {
            boss.func_70106_y();
            return;
        }
        boss.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        if (chest != null) {
            ((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).setLootTable(chest.field_184284_m);
        }
        ((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).setSpawnPos(pos);
        world.func_217376_c((Entity)boss);
    }

    public static BlockPos findSpawnPosForBoss(IServerWorld world, Entity boss, BlockPos pos) {
        BlockPos spawnPos = BossSpawnHandler.findAround(world, pos, 15, 10, (w, p) -> {
            Material materialBelow = w.func_180495_p(p.func_177977_b()).func_185904_a();
            if (!materialBelow.func_76220_a() && materialBelow != Material.field_151586_h) {
                return false;
            }
            for (int x = MathHelper.func_76141_d((float)((-boss.func_213311_cf() + 1.0f) / 2.0f)); x <= MathHelper.func_76123_f((float)((boss.func_213311_cf() - 1.0f) / 2.0f)); ++x) {
                for (int z = MathHelper.func_76141_d((float)((-boss.func_213311_cf() + 1.0f) / 2.0f)); z <= MathHelper.func_76123_f((float)((boss.func_213311_cf() - 1.0f) / 2.0f)); ++z) {
                    for (int y = 0; y <= MathHelper.func_76123_f((float)boss.func_213302_cg()); ++y) {
                        Material material = w.func_180495_p(p.func_177982_a(x, y, z)).func_185904_a();
                        if (material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_203243_f) continue;
                        return false;
                    }
                }
            }
            return true;
        });
        return spawnPos;
    }

    public static void spawnRandomBoss(IServerWorld world, BlockPos pos) {
        ArrayList<BossType> list = new ArrayList<BossType>(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        BossSpawnHandler.spawnBoss(world, pos, bossType, null);
    }

    public static BlockPos findAround(IServerWorld world, BlockPos start, int vRange, int hRange, BiPredicate<IBlockReader, BlockPos> predicate) {
        if (vRange < 1 && hRange < 1) {
            return null;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < hRange + 2; ++i) {
            for (int steps = 1; steps <= vRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.func_177982_a(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((IBlockReader)world, temp = temp.func_177982_a(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (world.func_234938_ad_() > start.func_177956_o() + (y += (y_offset *= -1))) continue;
            return null;
        }
        return null;
    }
}

