/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.CustomEntityRenderData;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BossType {
    private final EntityType entityToUse;
    private final ResourceLocation id;
    private ImmutableMap<Effect, Integer> potionEffects = ImmutableMap.of();
    private ImmutableMap<EquipmentSlotType, ItemStack> gearMap = ImmutableMap.of();
    private ImmutableMap<ResourceLocation, IAIParams> aiData = ImmutableMap.of();
    private ImmutableMap<Attribute, Float> attributes = ImmutableMap.of();
    private ImmutableMap<ResourceLocation, Integer> spawnTables = ImmutableMap.of();
    private ImmutableMap<String, Float> customAttributes = ImmutableMap.of();
    private String desc;
    private float scale = 1.0f;
    private int experienceDropped = 1;
    private int itemLootCount = 3;
    private boolean showBossBar = true;

    public BossType(EntityType entityToUse, ResourceLocation id) {
        this.entityToUse = entityToUse;
        this.id = id;
    }

    public MobEntity createBossEntity(World world) {
        Entity entity = this.entityToUse.func_200721_a(world);
        if (!(entity instanceof MobEntity)) {
            BrutalBosses.LOGGER.warn("Not supported boss entity:" + this.entityToUse.getRegistryName());
            return null;
        }
        ((BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)).setBossType(this);
        this.initForEntity((LivingEntity)((MobEntity)entity));
        return (MobEntity)entity;
    }

    public void initForClientEntity(LivingEntity entity) {
        if (entity instanceof CustomEntityRenderData) {
            ((CustomEntityRenderData)entity).setVisualScale(this.scale);
            ((CustomEntityRenderData)entity).setDimension(this.entityToUse.func_220334_j().func_220313_a(this.scale));
        }
    }

    public void initForEntity(LivingEntity boss) {
        this.initGear(boss);
        this.initStats(boss);
        this.initAI(boss);
        if (boss instanceof MobEntity) {
            ((MobEntity)boss).func_110163_bv();
            if (boss.func_233645_dx_().func_233790_b_(Attributes.field_233819_b_)) {
                // empty if block
            }
        }
        boss.func_200203_b((ITextComponent)new StringTextComponent(this.desc));
        boss.func_174805_g(true);
    }

    private void initStats(LivingEntity boss) {
        float healthPct = boss.func_110143_aJ() / boss.func_110138_aP();
        for (Map.Entry attributeEntry : this.attributes.entrySet()) {
            if (boss.func_233645_dx_().func_233790_b_((Attribute)attributeEntry.getKey())) {
                if (attributeEntry.getKey() == Attributes.field_233818_a_ || attributeEntry.getKey() == Attributes.field_233823_f_) {
                    boss.func_110148_a((Attribute)attributeEntry.getKey()).func_111128_a((double)((Float)attributeEntry.getValue()).floatValue() * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get());
                    continue;
                }
                boss.func_110148_a((Attribute)attributeEntry.getKey()).func_111128_a((double)((Float)attributeEntry.getValue()).floatValue());
                continue;
            }
            BrutalBosses.LOGGER.debug("Boss:" + this.id.toString() + " Attribute: " + ((Attribute)attributeEntry.getKey()).func_233754_c_() + " is not applicable to: " + this.entityToUse.getRegistryName());
        }
        boss.func_70606_j(boss.func_110138_aP() * healthPct);
        for (Map.Entry effectEntry : this.potionEffects.entrySet()) {
            boss.func_195064_c(new EffectInstance((Effect)effectEntry.getKey(), 10000000, ((Integer)effectEntry.getValue()).intValue()));
        }
    }

    private void initGear(LivingEntity boss) {
        if (boss instanceof MobEntity) {
            for (Map.Entry gearEntry : this.gearMap.entrySet()) {
                boss.func_184201_a((EquipmentSlotType)gearEntry.getKey(), (ItemStack)gearEntry.getValue());
            }
        }
    }

    private void initAI(LivingEntity boss) {
        if (this.customAttributes.containsKey((Object)"removespellcastinggoals") && boss instanceof MobEntity) {
            Iterator iterator = ((MobEntity)boss).field_70714_bg.field_220892_d.iterator();
            while (iterator.hasNext()) {
                PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
                if (!(goal.func_220772_j() instanceof SpellcastingIllagerEntity.UseSpellGoal)) continue;
                goal.func_75251_c();
                iterator.remove();
            }
        }
        for (Map.Entry data : this.aiData.entrySet()) {
            if (!BossTypeManager.instance.aiCreatorRegistry.containsKey(data.getKey())) continue;
            BossTypeManager.instance.aiCreatorRegistry.get(data.getKey()).accept((Entity)boss, (IAIParams)data.getValue());
        }
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public void setEffects(ImmutableMap<Effect, Integer> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public void setGear(ImmutableMap<EquipmentSlotType, ItemStack> gearMap) {
        this.gearMap = gearMap;
    }

    public void setAttributes(ImmutableMap<Attribute, Float> attributes) {
        this.attributes = attributes;
    }

    public void setAIData(ImmutableMap<ResourceLocation, IAIParams> aiData) {
        this.aiData = aiData;
    }

    public EntityType getEntityType() {
        return this.entityToUse;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setSpawnTable(ImmutableMap<ResourceLocation, Integer> spawnData) {
        this.spawnTables = spawnData;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof BossType) {
            return this.id.equals((Object)((BossType)other).id);
        }
        return false;
    }

    public ImmutableMap<ResourceLocation, Integer> getSpawnTables() {
        return this.spawnTables;
    }

    public void setVisualScale(float scale) {
        this.scale = scale;
    }

    public float getVisualScale() {
        return this.scale;
    }

    public float getCustomAttributeValueOrDefault(String attributeID, float defaultValue) {
        return ((Float)this.customAttributes.getOrDefault((Object)attributeID, (Object)Float.valueOf(defaultValue))).floatValue();
    }

    public void setCustomAttributes(ImmutableMap<String, Float> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public int getExperienceDrop() {
        return this.experienceDropped;
    }

    public void setExperienceDrop(int exp) {
        this.experienceDropped = exp;
    }

    public IAIParams getAIParams(ResourceLocation id) {
        return (IAIParams)this.aiData.get((Object)id);
    }

    public int getItemLootCount() {
        return this.itemLootCount;
    }

    public void setItemLootCount(int itemLootCount) {
        this.itemLootCount = itemLootCount;
    }

    public CompoundNBT serializeToClient() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("id", this.id.toString());
        compoundNBT.func_74778_a("etype", this.entityToUse.getRegistryName().toString());
        compoundNBT.func_74776_a("scale", this.scale);
        return compoundNBT;
    }

    public static BossType deserializeAtClient(CompoundNBT compoundNBT) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)compoundNBT.func_74779_i("id"));
        ResourceLocation entity = ResourceLocation.func_208304_a((String)compoundNBT.func_74779_i("etype"));
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
        if (type == null) {
            return null;
        }
        BossType bossType = new BossType(type, id);
        bossType.setVisualScale(compoundNBT.func_74760_g("scale"));
        return bossType;
    }

    public void setBossBar(boolean show) {
        this.showBossBar = show;
    }

    public boolean showBossBar() {
        return this.showBossBar;
    }
}

