/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.ai.BigFireballAttackGoal;
import com.brutalbosses.entity.ai.ChargeGoal;
import com.brutalbosses.entity.ai.ChasingGoal;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.ItemThrowAttackGoal;
import com.brutalbosses.entity.ai.LavaRescueGoal;
import com.brutalbosses.entity.ai.MeleeHitGoal;
import com.brutalbosses.entity.ai.MeleeShieldAttackGoal;
import com.brutalbosses.entity.ai.OutofCombatRegen;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.ai.SmallFireballAttackGoal;
import com.brutalbosses.entity.ai.SnowballAttackGoal;
import com.brutalbosses.entity.ai.SpitCobwebGoal;
import com.brutalbosses.entity.ai.SummonMobsGoal;
import com.brutalbosses.entity.ai.TemporaryPotionGoal;
import com.brutalbosses.entity.ai.WhirldwindMelee;
import com.brutalbosses.entity.ai.WitherSkullAttackGoal;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class BossTypeManager {
    public Map<ResourceLocation, BossType> bosses = ImmutableMap.of();
    public Set<ResourceLocation> entityTypes = ImmutableSet.of();
    public static final BossTypeManager instance = new BossTypeManager();
    public Map<ResourceLocation, BiConsumer<Entity, IAIParams>> aiCreatorRegistry = ImmutableMap.of();
    public Map<ResourceLocation, Function<JsonObject, IAIParams>> aiParamParsers = ImmutableMap.of();
    public ImmutableMap<ResourceLocation, List<BossType>> lootTableSpawnEntries = ImmutableMap.of();

    private BossTypeManager() {
        this.registerAI(new ResourceLocation("minecraft:randomwalk"), (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new RandomWalkingGoal((CreatureEntity)entity, 0.8, 20)), null);
        this.registerAI(new ResourceLocation("minecraft:meleeattack"), (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new MeleeAttackGoal((CreatureEntity)entity, 1.0, true)), null);
        this.registerAI(new ResourceLocation("minecraft:crossbow"), (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new RangedCrossbowAttackGoal((MonsterEntity)((ICrossbowUser)((IRangedAttackMob)((MonsterEntity)entity))), 1.0, 30.0f)), null);
        this.registerAI(MeleeShieldAttackGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2001, (Goal)new MeleeShieldAttackGoal((MobEntity)entity, 1.0)), null);
        this.registerAI(new ResourceLocation("minecraft:target"), (entity, params) -> ((MobEntity)entity).field_70715_bh.func_75776_a(-2000, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, true)), null);
        this.registerAI(LavaRescueGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new LavaRescueGoal((MobEntity)entity)), null);
        this.registerAI(ChasingGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2001, (Goal)new ChasingGoal((MobEntity)entity, (IAIParams)params)), ChasingGoal.ChaseParams::new);
        this.registerAI(SmallFireballAttackGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new SmallFireballAttackGoal((MobEntity)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(WitherSkullAttackGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new WitherSkullAttackGoal((MobEntity)entity, (IAIParams)params)), WitherSkullAttackGoal.WitherSkullParams::new);
        this.registerAI(SnowballAttackGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new SnowballAttackGoal((MobEntity)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(OutofCombatRegen.ID, (entity, params) -> ((MobEntity)entity).field_70715_bh.func_75776_a(-2000, (Goal)new OutofCombatRegen((MobEntity)entity, (IAIParams)params)), OutofCombatRegen.CombatParams::new);
        this.registerAI(SpitCobwebGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new SpitCobwebGoal((MobEntity)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(SummonMobsGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new SummonMobsGoal((MobEntity)entity, (IAIParams)params)), SummonMobsGoal.SummonParams::new);
        this.registerAI(WhirldwindMelee.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new WhirldwindMelee((MobEntity)entity, (IAIParams)params)), WhirldwindMelee.WhirldWindParams::new);
        this.registerAI(MeleeHitGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new MeleeHitGoal((MobEntity)entity, (IAIParams)params)), MeleeHitGoal.MeleeHitParams::new);
        this.registerAI(ChargeGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new ChargeGoal((MobEntity)entity, (IAIParams)params)), ChargeGoal.ChargeParams::new);
        this.registerAI(BigFireballAttackGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new BigFireballAttackGoal((MobEntity)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(ItemThrowAttackGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new ItemThrowAttackGoal((MobEntity)entity, (IAIParams)params)), ItemThrowAttackGoal.ItemThrowParams::new);
        this.registerAI(TemporaryPotionGoal.ID, (entity, params) -> ((MobEntity)entity).field_70714_bg.func_75776_a(-2000, (Goal)new TemporaryPotionGoal((MobEntity)entity, (IAIParams)params)), TemporaryPotionGoal.TempPotionParams::new);
    }

    public void registerAI(ResourceLocation ID, BiConsumer<Entity, IAIParams> aiCreator, @Nullable Function<JsonObject, IAIParams> paramsParser) {
        ImmutableMap.Builder aiRegistry = ImmutableMap.builder();
        ImmutableMap.Builder aiSupplier = ImmutableMap.builder();
        aiRegistry.putAll(this.aiCreatorRegistry);
        aiSupplier.putAll(this.aiParamParsers);
        aiRegistry.put((Object)ID, aiCreator);
        if (paramsParser != null) {
            aiSupplier.put((Object)ID, paramsParser);
        }
        for (int i = 1; i < 5; ++i) {
            ResourceLocation additionalID = new ResourceLocation(ID.func_110624_b(), ID.func_110623_a() + i);
            aiRegistry.put((Object)additionalID, aiCreator);
            if (paramsParser == null) continue;
            aiSupplier.put((Object)additionalID, paramsParser);
        }
        this.aiCreatorRegistry = aiRegistry.build();
        this.aiParamParsers = aiSupplier.build();
    }

    public void afterLoad() {
        ImmutableSet.Builder entityTypes = ImmutableSet.builder();
        HashMap<ResourceLocation, List> tempSpawns = new HashMap<ResourceLocation, List>();
        for (BossType bossType : this.bosses.values()) {
            entityTypes.add((Object)bossType.getEntityType().getRegistryName());
            BrutalBosses.LOGGER.info("Loaded boss variant for: " + bossType.getEntityType().getRegistryName());
            for (Map.Entry spawnEntry : bossType.getSpawnTables().entrySet()) {
                List contained = tempSpawns.computeIfAbsent((ResourceLocation)spawnEntry.getKey(), loc -> new ArrayList());
                for (int i = 0; i < (Integer)spawnEntry.getValue(); ++i) {
                    contained.add(bossType);
                }
            }
        }
        this.entityTypes = entityTypes.build();
        ImmutableMap.Builder spawnMap = ImmutableMap.builder();
        for (Map.Entry entry : tempSpawns.entrySet()) {
            ImmutableList.Builder bossList = ImmutableList.builder();
            bossList.addAll((Iterable)entry.getValue());
            spawnMap.put(entry.getKey(), (Object)bossList.build());
        }
        this.lootTableSpawnEntries = spawnMap.build();
    }

    public void register() {
        CapabilityManager.INSTANCE.register(BossCapability.class, (Capability.IStorage)new Capability.IStorage<BossCapability>(){

            @Nullable
            public INBT writeNBT(Capability<BossCapability> capability, BossCapability instance, Direction side) {
                return capability.writeNBT((Object)instance, side);
            }

            public void readNBT(Capability<BossCapability> capability, BossCapability instance, Direction side, INBT nbt) {
                capability.readNBT((Object)instance, side, nbt);
            }
        }, BossCapability::new);
    }

    public boolean isValidBossEntity(Entity entity) {
        return this.entityTypes.contains(entity.func_200600_R().getRegistryName());
    }

    public void setBossTypes(ImmutableMap<ResourceLocation, BossType> bossTypes) {
        this.bosses = bossTypes;
    }
}

