/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;

public class ChargeGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:charge");
    private static final AttributeModifier speedMod = new AttributeModifier("brutalbosses:speedbuff", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final MobEntity mob;
    private ChargeParams params;
    private LivingEntity target = null;
    private int ticksToNextUpdate = 0;
    private boolean isCharging = false;

    public ChargeGoal(MobEntity mob, IAIParams params) {
        this.params = (ChargeParams)params;
        this.mob = mob;
    }

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
    }

    public void func_75246_d() {
        Path path;
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr >= (double)this.params.minDistance && !this.isCharging && (path = this.mob.func_70661_as().func_75505_d()) != null) {
            this.isCharging = true;
            this.ticksToNextUpdate = (int)this.params.duration;
            this.mob.func_110148_a(Attributes.field_233821_d_).func_233767_b_(speedMod);
            this.mob.func_70659_e((float)this.mob.func_110148_a(Attributes.field_233821_d_).func_111126_e());
            this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_(), SoundEvents.field_189106_R, this.mob.func_184176_by(), 1.0f, 1.0f);
            double d0 = -MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
            double d1 = MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
            if (this.mob.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.mob.func_226277_ct_() + d0, this.mob.func_226283_e_(0.5), this.mob.func_226281_cx_() + d1, 20, d0, 0.0, d1, 0.0);
            }
            return;
        }
        if (this.isCharging) {
            this.isCharging = false;
            this.ticksToNextUpdate = (int)(this.params.interval + (float)(BrutalBosses.rand.nextInt(20) - 10));
            this.mob.func_110148_a(Attributes.field_233821_d_).func_111124_b(speedMod);
            this.mob.func_70659_e((float)this.mob.func_110148_a(Attributes.field_233821_d_).func_111126_e());
            this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_(), SoundEvents.field_189106_R, this.mob.func_184176_by(), 1.0f, 1.0f);
            double d0 = -MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
            double d1 = MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
            if (this.mob.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.mob.func_226277_ct_() + d0, this.mob.func_226283_e_(0.5), this.mob.func_226281_cx_() + d1, 20, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class ChargeParams
    extends IAIParams.DefaultParams {
        private float minDistance = 3.0f;
        private float duration = 20.0f;
        private float interval = 200.0f;
        public static final String CHARGE_MINDIST = "mindist";
        public static final String CHARGE_DURATION = "duration";
        public static final String CHARGE_COOLDOWN = "interval";

        public ChargeParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHARGE_MINDIST)) {
                this.minDistance = jsonElement.get(CHARGE_MINDIST).getAsFloat();
            }
            if (jsonElement.has(CHARGE_DURATION)) {
                this.duration = jsonElement.get(CHARGE_DURATION).getAsFloat();
            }
            if (jsonElement.has(CHARGE_COOLDOWN)) {
                this.interval = jsonElement.get(CHARGE_COOLDOWN).getAsFloat();
            }
            return this;
        }
    }
}

