/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ChasingGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:chasetarget");
    private final MobEntity mob;
    private float chaseDist;
    private LivingEntity target = null;
    private final ChaseParams params;
    private int ticksToNextUpdate = 0;

    public ChasingGoal(MobEntity mob, IAIParams params) {
        this.params = (ChaseParams)params;
        this.chaseDist = this.params.chasedistance * this.params.chasedistance;
        this.mob = mob;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
    }

    public void func_75246_d() {
        this.mob.func_70671_ap().func_220679_a(this.target.func_226277_ct_(), this.target.func_226280_cw_(), this.target.func_226281_cx_());
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr <= (double)this.chaseDist && this.mob.func_70635_at().func_75522_a((Entity)this.target)) {
            this.mob.func_70661_as().func_75499_g();
        } else {
            Path path = this.mob.func_70661_as().func_75505_d();
            if (path != null) {
                BlockPos endPos;
                double endPosDist;
                PathPoint endNode = path.func_75870_c();
                if (endNode != null && ((endPosDist = this.target.func_70092_e((double)(endPos = new BlockPos(endNode.field_75839_a, endNode.field_75837_b, endNode.field_75838_c)).func_177958_n(), (double)endPos.func_177956_o(), (double)endPos.func_177952_p())) > (double)this.chaseDist || !this.mob.func_70635_at().func_75522_a((Entity)this.target))) {
                    this.mob.func_70661_as().func_75497_a((Entity)this.target, 1.0);
                }
            } else {
                this.mob.func_70661_as().func_75497_a((Entity)this.target, 1.0);
            }
        }
    }

    public static class ChaseParams
    extends IAIParams.DefaultParams {
        private float chasedistance = 2.0f;
        private static final String CHASE_DIST = "chasedistance";

        public ChaseParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHASE_DIST)) {
                this.chasedistance = jsonElement.get(CHASE_DIST).getAsFloat();
            }
            return this;
        }
    }
}

