/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.capability.BossCapability;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class MeleeShieldAttackGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:shieldmelee");
    private final BossType bossType;
    protected final MobEntity mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final double attackInterval;
    private long lastCanUseCheck;
    int shieldTicks = 0;

    public MeleeShieldAttackGoal(MobEntity entity, double speed) {
        this.mob = entity;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = true;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.bossType = ((BossCapability)this.mob.getCapability(BossCapability.BOSS_CAP).orElse(null)).getBossType();
        this.attackInterval = this.bossType.getCustomAttributeValueOrDefault("attack_speed", 1.0f);
    }

    public boolean func_75250_a() {
        long timeDiff = this.mob.field_70170_p.func_82737_E();
        if (timeDiff - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = timeDiff;
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity == null || !livingentity.func_70089_S()) {
            return false;
        }
        this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.func_70661_as().func_75500_f();
        }
        if (!this.mob.func_213389_a(livingentity.func_233580_cy_())) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }

    public void func_75249_e() {
        this.mob.func_70661_as().func_75484_a(this.path, this.speedModifier);
        this.mob.func_213395_q(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void func_75251_c() {
        this.mob.func_213395_q(false);
        this.mob.func_70661_as().func_75499_g();
        this.mob.func_184598_c(Hand.MAIN_HAND);
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.mob.func_70638_az();
        this.mob.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.func_70635_at().func_75522_a((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.func_70092_e(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.func_70681_au().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.func_226277_ct_();
            this.pathedTargetY = livingentity.func_226278_cu_();
            this.pathedTargetZ = livingentity.func_226281_cx_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.func_70681_au().nextInt(7);
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.func_70661_as().func_75497_a((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity target, double dist) {
        double d0 = this.getAttackReachSqr(target);
        if (dist <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.func_184609_a(Hand.MAIN_HAND);
            this.mob.func_70652_k((Entity)target);
        }
        if (this.shieldTicks == -20 && BrutalBosses.rand.nextInt(20) == 0) {
            this.mob.func_184598_c(Hand.OFF_HAND);
            this.shieldTicks = BrutalBosses.rand.nextInt(10) + 20;
        }
        if (this.shieldTicks > -20) {
            --this.shieldTicks;
            if (this.shieldTicks == 0) {
                this.mob.func_184602_cy();
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = (int)(20.0 / this.attackInterval);
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return (double)(this.mob.func_213311_cf() * 2.0f * this.mob.func_213311_cf() * 2.0f + entity.func_213311_cf()) * (double)this.bossType.getVisualScale();
    }
}

