/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class WhirldwindMelee
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:whirldwind");
    private final MobEntity mob;
    private LivingEntity target = null;
    private WhirldWindParams params;
    private int attackTimer = 0;

    public WhirldwindMelee(MobEntity mob, IAIParams params) {
        this.params = (WhirldWindParams)params;
        this.mob = mob;
    }

    public boolean func_75250_a() {
        LivingEntity target = this.mob.func_70638_az();
        if (target != null && target.func_70089_S()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void func_75246_d() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        if (distSqr < (double)(this.params.attackDistance * this.params.attackDistance) && BrutalBosses.rand.nextInt(40) == 0) {
            this.attackTimer = this.params.cooldown;
            List entities = this.mob.field_70170_p.func_225317_b(PlayerEntity.class, this.mob.func_174813_aQ().func_72314_b(2.0, 0.5, 2.0));
            if (!entities.contains(this.mob.func_70638_az())) {
                entities.add(this.mob.func_70638_az());
            }
            for (LivingEntity livingentity : entities) {
                if (livingentity == this.mob) continue;
                if (this.params.knockup) {
                    livingentity.func_213317_d(livingentity.func_213322_ci().func_72441_c(0.0, (double)(this.params.knockback / 5.0f), 0.0));
                } else {
                    livingentity.func_233627_a_(this.params.knockback, (double)MathHelper.func_76126_a((float)(livingentity.field_70177_z * (float)Math.PI)), (double)(-MathHelper.func_76134_b((float)(livingentity.field_70177_z * (float)Math.PI))));
                }
                this.mob.func_184609_a(Hand.MAIN_HAND);
                float damage = this.params.extraDamage;
                if (this.mob.func_233645_dx_().func_233790_b_(Attributes.field_233823_f_)) {
                    damage = (float)((double)damage + this.mob.func_233637_b_(Attributes.field_233823_f_));
                }
                livingentity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.mob), damage);
                if (this.params.onHitEffect == null) continue;
                livingentity.func_195064_c(new EffectInstance(this.params.onHitEffect, this.params.potionduration, this.params.potionlevel));
            }
            this.mob.field_70170_p.func_184148_a(null, this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_(), SoundEvents.field_187730_dW, this.mob.func_184176_by(), 1.0f, 1.0f);
            double d0 = -MathHelper.func_76126_a((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
            double d1 = MathHelper.func_76134_b((float)(this.mob.field_70177_z * ((float)Math.PI / 180)));
            if (this.mob.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.mob.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197603_N, this.mob.func_226277_ct_() + d0, this.mob.func_226283_e_(0.5), this.mob.func_226281_cx_() + d1, 2, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class WhirldWindParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 4.0f;
        private float extraDamage = 2.0f;
        private Effect onHitEffect = null;
        private float knockback = 4.0f;
        private int cooldown = 80;
        private int potionlevel = 1;
        private int potionduration = 60;
        private boolean knockup = false;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "extradamage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";
        private static final String KNOCK_UP = "knockup";

        public WhirldWindParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(KNOCK_UP)) {
                this.knockup = jsonElement.get(KNOCK_UP).getAsBoolean();
            }
            if (jsonElement.has(POTION)) {
                ResourceLocation effectID = new ResourceLocation(jsonElement.get(POTION).getAsString());
                this.onHitEffect = (Effect)ForgeRegistries.POTIONS.getValue(effectID);
            }
            return this;
        }
    }
}

