/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.entity.ModEntities;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.entity.thrownentity.CSpriteRenderer;
import com.brutalbosses.event.SUpdateBossInfoPacketInfoHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientEventHandler {
    private static Map<Entity, ClientBossUI> bossInfoMap = new HashMap<Entity, ClientBossUI>();

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        bossInfoMap.clear();
        Minecraft.func_71410_x().field_71456_v.func_184046_j().field_184060_g.clear();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.func_201670_d() || event.player.field_70170_p.func_82737_E() % 5L != 0L) {
            return;
        }
        Entity target = Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x instanceof EntityRayTraceResult ? ((EntityRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216348_a() : null;
        ClientEventHandler.checkEntity(target);
        Iterator<Map.Entry<Entity, ClientBossUI>> iterator = bossInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, ClientBossUI> entry = iterator.next();
            entry.getValue().bossInfo.func_186765_a((SUpdateBossInfoPacket)new SUpdateBossInfoPacketInfoHolder(entry.getKey(), entry.getValue().cap, SUpdateBossInfoPacket.Operation.UPDATE_PCT));
            if (!entry.getKey().func_70089_S() || entry.getValue().timeOut < entry.getKey().field_70170_p.func_82737_E()) {
                Minecraft.func_71410_x().field_71456_v.func_184046_j().field_184060_g.remove(entry.getValue().bossInfo.func_186737_d());
                iterator.remove();
                continue;
            }
            if (!event.player.func_70685_l(entry.getKey())) continue;
            entry.getValue().timeOut = event.player.field_70170_p.func_82737_E() + 600L;
        }
    }

    private static ClientBossUI createBossGUI(Entity target, BossCapability cap) {
        ClientBossUI ui = new ClientBossUI(new ClientBossInfo((SUpdateBossInfoPacket)new SUpdateBossInfoPacketInfoHolder(target, cap, SUpdateBossInfoPacket.Operation.ADD)), target, cap);
        Minecraft.func_71410_x().field_71456_v.func_184046_j().field_184060_g.put(ui.bossInfo.func_186737_d(), ui.bossInfo);
        return ui;
    }

    public static void checkEntity(Entity target) {
        BossCapability cap;
        if (target instanceof LivingEntity && (cap = (BossCapability)target.getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss() && cap.getBossType().showBossBar()) {
            if (bossInfoMap.containsKey(target)) {
                ClientBossUI ui = bossInfoMap.get(target);
                ui.timeOut = target.field_70170_p.func_82737_E() + 600L;
            } else {
                bossInfoMap.put(target, ClientEventHandler.createBossGUI(target, cap));
            }
        }
    }

    public static void initRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWN_ITEMC, manager -> new CSpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af(), 1.0f, true));
    }

    private static class ClientBossUI {
        private ClientBossInfo bossInfo;
        private long timeOut;
        private Entity boss;
        private BossCapability cap;

        private ClientBossUI(ClientBossInfo bossInfo, Entity boss, BossCapability cap) {
            this.bossInfo = bossInfo;
            this.timeOut = boss.field_70170_p.func_82737_E() + 600L;
            this.boss = boss;
            this.cap = cap;
        }
    }
}

