/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossJsonListener;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.Network;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class EventHandler {
    @SubscribeEvent
    public static void applyProjectileDamageBoost(LivingHurtEvent event) {
        BossCapability cap;
        if (event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntity() instanceof MobEntity) {
            BossCapability cap2 = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null);
            if (cap2 != null && cap2.isBoss()) {
                Network.instance.sendPacket((ServerPlayerEntity)event.getSource().func_76346_g(), new BossOverlayMessage(event.getEntity().func_145782_y()));
            }
            return;
        }
        if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76346_g() != null && (cap = (BossCapability)event.getSource().func_76346_g().getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss()) {
            event.setAmount((float)((double)(event.getAmount() + cap.getBossType().getCustomAttributeValueOrDefault("projectile_damage_bonus", 0.0f)) * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get()));
        }
    }

    @SubscribeEvent
    public static void playerClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)BrutalBosses.config.getCommonConfig().printChestLoottable.get()).booleanValue() || event.getWorld().func_201670_d()) {
            return;
        }
        TileEntity te = event.getEntity().field_70170_p.func_175625_s(event.getPos());
        if (te instanceof LockableLootTileEntity && ((LockableLootTileEntity)te).field_184284_m != null) {
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("[Loottable: " + ((LockableLootTileEntity)te).field_184284_m + "]").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ((LockableLootTileEntity)te).field_184284_m.toString()))), event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void onBossDeath(LivingDeathEvent event) {
        BossCapability cap;
        if (!event.getEntity().field_70170_p.func_201670_d() && event.getSource().func_76346_g() instanceof ServerPlayerEntity && (cap = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss()) {
            int orbValue;
            for (int exp = cap.getBossType().getExperienceDrop(); exp > 0; exp -= orbValue) {
                orbValue = ExperienceOrbEntity.func_70527_a((int)exp);
                event.getEntity().field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), orbValue));
            }
            int gearDropCount = Math.min(EquipmentSlotType.values().length, (int)cap.getBossType().getCustomAttributeValueOrDefault("dropgear", 0.0f));
            for (int i = 0; i < gearDropCount; ++i) {
                ItemEntity itementity = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), event.getEntityLiving().func_184582_a(EquipmentSlotType.values()[i]));
                event.getEntity().field_70170_p.func_217376_c((Entity)itementity);
            }
            if (cap.getLootTable() != null) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)event.getEntity().field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)event.getEntity().func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)event.getSource().func_76346_g()).func_186469_a(((ServerPlayerEntity)event.getSource().func_76346_g()).func_184817_da());
                LootTable loottable = event.getEntity().field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(cap.getLootTable());
                List list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
                if (list.isEmpty()) {
                    return;
                }
                for (int i = 0; i < cap.getBossType().getItemLootCount(); ++i) {
                    ItemEntity itementity = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), (ItemStack)list.get(BrutalBosses.rand.nextInt(list.size())));
                    event.getEntity().field_70170_p.func_217376_c((Entity)itementity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity.field_70170_p.field_72995_K || BossTypeManager.instance.isValidBossEntity(entity)) {
            evt.addCapability(BossCapability.ID, (ICapabilityProvider)new BossCapability(entity));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)BossJsonListener.instance);
    }

    @SubscribeEvent
    public static void onTrack(PlayerEvent.StartTracking event) {
        BossCapability bossCapability;
        Entity entity = event.getTarget();
        PlayerEntity playerEntity = event.getPlayer();
        if (playerEntity instanceof ServerPlayerEntity && (bossCapability = (BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)) != null) {
            Network.instance.sendPacket((ServerPlayerEntity)playerEntity, new BossCapMessage(bossCapability));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> Network.instance.sendPacket((ServerPlayerEntity)event.getPlayer(), new BossTypeSyncMessage(BossTypeManager.instance.bosses.values())));
    }
}

