/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.capability.BossCapability;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MeleeAttackGoal.class})
public class MeleeAttackGoalMixin {
    @Shadow
    private int field_234037_i_;
    @Shadow
    @Final
    protected CreatureEntity field_75441_b;
    private float attackSpeedMod = 1.0f;
    private float scale = 1.0f;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void load(CreatureEntity mob, double p_i1636_2_, boolean p_i1636_4_, CallbackInfo ci) {
        BossCapability cap = (BossCapability)mob.getCapability(BossCapability.BOSS_CAP).orElse(null);
        if (cap != null && cap.isBoss()) {
            this.attackSpeedMod = cap.getBossType().getCustomAttributeValueOrDefault("attack_speed", 1.0f);
            this.scale = cap.getBossType().getVisualScale();
        }
    }

    @Inject(method={"checkAndPerformAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/MeleeAttackGoal;resetAttackCooldown()V", shift=At.Shift.AFTER)})
    private void resetAttackCooldown(LivingEntity p_190102_1_, double p_190102_2_, CallbackInfo ci) {
        this.field_234037_i_ = (int)(20.0f / this.attackSpeedMod);
    }

    @Inject(method={"getAttackReachSqr"}, at={@At(value="HEAD")}, cancellable=true)
    private void getAttackReachSqr(LivingEntity entity, CallbackInfoReturnable<Double> cir) {
        cir.setReturnValue((Object)((double)(this.field_75441_b.func_213311_cf() * 2.0f * this.field_75441_b.func_213311_cf() * 2.0f + entity.func_213311_cf()) * (double)this.scale));
    }
}

