/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.IOnProjectileHit;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProjectileEntity.class})
public abstract class ProjectileHitActionMixin
extends Entity
implements IOnProjectileHit {
    private long maxLifeTime = 0L;
    private Consumer<RayTraceResult> onHitAction = null;
    private float damageModifier = 0.0f;

    public ProjectileHitActionMixin(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    @Inject(method={"onHit"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHitCallback(RayTraceResult rayTraceResult, CallbackInfo ci) {
        if (this.onHitAction != null) {
            this.onHitAction.accept(rayTraceResult);
            this.onHitAction = null;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.maxLifeTime != 0L && this.field_70170_p.func_82737_E() > this.maxLifeTime) {
            this.func_70106_y();
        }
    }

    public boolean func_70039_c(CompoundNBT nbt) {
        if (this.maxLifeTime != 0L) {
            return false;
        }
        return super.func_70039_c(nbt);
    }

    @Override
    public void setOnHitAction(Consumer<RayTraceResult> action) {
        this.onHitAction = action;
    }

    @Override
    public void setAddDamage(float modifier) {
        this.damageModifier = modifier;
    }

    @Override
    public float getAddDamage() {
        return this.damageModifier;
    }

    @Override
    public void setMaxLifeTime(long maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }
}

