/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class BossCapMessage
implements IMessage {
    BossCapability cap = null;
    private int entityID = -1;
    private CompoundNBT nbt = null;

    public BossCapMessage(BossCapability cap) {
        this.cap = cap;
    }

    public BossCapMessage() {
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.cap.getEntity().func_145782_y());
        buffer.func_150786_a((CompoundNBT)this.cap.serializeNBT());
    }

    @Override
    public BossCapMessage read(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.nbt = buffer.func_150793_b();
        return this;
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            BrutalBosses.LOGGER.error("Boss capability message sent to the wrong side!", (Throwable)new Exception());
        } else {
            Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(this.entityID);
            if (entity != null) {
                ((BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)).deserializeNBT((INBT)this.nbt);
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

