/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.network.IMessage;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaParticleMessage
implements IMessage {
    private static final float WIDTH = 0.8f;
    private static final float CITIZEN_HEIGHT = 2.0f;
    private double x;
    private double y;
    private double z;
    private BasicParticleType type;

    public VanillaParticleMessage() {
    }

    public VanillaParticleMessage(double x, double y, double z, BasicParticleType type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    private void spawnParticles(BasicParticleType particleType, World world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_151103_aS)), x + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, y + 1.0 + (double)(rand.nextFloat() * 2.0f), z + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, d0, d1, d2);
        }
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.func_192572_a(this.type.getRegistryName());
    }

    @Override
    public IMessage read(PacketBuffer buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.type = (BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.func_192575_l());
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            BrutalBosses.LOGGER.error("Boss capability message sent to the wrong side!", (Throwable)new Exception());
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        this.spawnParticles(this.type, (World)world, this.x, this.y, this.z);
    }
}

