/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.compat.Compat;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.world.PostStructureInfoGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.material.Material;

public class BossSpawnHandler {
    public static void onChestPlaced(ServerLevelAccessor world, RandomizableContainerBlockEntity chest) {
        List possibleBosses = (List)BossTypeManager.instance.lootTableSpawnEntries.get((Object)chest.f_59605_);
        if (possibleBosses != null && !possibleBosses.isEmpty()) {
            if (BrutalBosses.rand.nextInt(100) > (Integer)BrutalBosses.config.getCommonConfig().globalBossSpawnChance.get()) {
                return;
            }
            BossType bossType = (BossType)possibleBosses.get(BrutalBosses.rand.nextInt(possibleBosses.size()));
            if (bossType.getID().m_135815_().equals("dummyboss")) {
                return;
            }
            BossSpawnHandler.spawnBoss(world, chest.m_58899_(), bossType, chest);
        } else if (((Boolean)BrutalBosses.config.getCommonConfig().printChestLoottable.get()).booleanValue()) {
            BrutalBosses.LOGGER.info("Chest with Loottable: " + chest.f_59605_ + " not associated with any boss spawn");
        }
    }

    public static void spawnBoss(ServerLevelAccessor world, BlockPos pos, BossType bossType, @Nullable RandomizableContainerBlockEntity chest) {
        BlockPos spawnPos;
        Mob boss = bossType.createBossEntity((Level)world.m_6018_());
        if (boss == null) {
            return;
        }
        if (chest != null) {
            String structname = "unkown structure";
            if (world instanceof PostStructureInfoGetter && ((PostStructureInfoGetter)world).getStructure() != null) {
                structname = ((PostStructureInfoGetter)world).getStructure().m_67098_();
            }
            ResourceLocation lootTable = chest.f_59605_;
            BrutalBosses.LOGGER.debug("Spawning " + bossType.getID() + " at " + pos + " at " + chest.m_5446_().getString() + " with:" + lootTable + " in " + structname);
        }
        if ((spawnPos = BossSpawnHandler.findSpawnPosForBoss((BlockGetter)world, (Entity)boss, pos)) == null) {
            boss.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        boss.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        if (chest != null) {
            ((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).setLootTable(chest.f_59605_);
        }
        ((BossCapability)boss.getCapability(BossCapability.BOSS_CAP).orElse(null)).setSpawnPos(pos);
        Compat.applyAllCompats(world, bossType, pos, (Entity)boss);
        if (!boss.m_146910_()) {
            world.m_7967_((Entity)boss);
        }
    }

    public static BlockPos findSpawnPosForBoss(BlockGetter world, Entity boss, BlockPos pos) {
        BlockPos spawnPos = BossSpawnHandler.findAround(world, pos, 15, 10, (w, p) -> {
            Material materialBelow = w.m_8055_(p.m_7495_()).m_60767_();
            if (!materialBelow.m_76333_() && materialBelow != Material.f_76305_) {
                return false;
            }
            for (int x = Mth.m_14143_((float)((-boss.m_20205_() + 1.0f) / 2.0f)); x <= Mth.m_14167_((float)((boss.m_20205_() - 1.0f) / 2.0f)); ++x) {
                for (int z = Mth.m_14143_((float)((-boss.m_20205_() + 1.0f) / 2.0f)); z <= Mth.m_14167_((float)((boss.m_20205_() - 1.0f) / 2.0f)); ++z) {
                    for (int y = 0; y <= Mth.m_14167_((float)boss.m_20206_()); ++y) {
                        Material material = w.m_8055_(p.m_142082_(x, y, z)).m_60767_();
                        if (material == Material.f_76296_ || material == Material.f_76305_ || material == Material.f_76301_) continue;
                        return false;
                    }
                }
            }
            return true;
        });
        return spawnPos;
    }

    public static void spawnRandomBoss(ServerLevelAccessor world, BlockPos pos) {
        ArrayList<BossType> list = new ArrayList<BossType>(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        BossSpawnHandler.spawnBoss(world, pos, bossType, null);
    }

    public static BlockPos findAround(BlockGetter world, BlockPos start, int vRange, int hRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (vRange < 1 && hRange < 1) {
            return null;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < hRange + 2; ++i) {
            for (int steps = 1; steps <= vRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.m_142082_(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test(world, temp = temp.m_142082_(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test(world, temp = temp.m_142082_(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test(world, temp = temp.m_142082_(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test(world, temp = temp.m_142082_(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (world.m_141928_() > start.m_123342_() + (y += (y_offset *= -1))) continue;
            return null;
        }
        return null;
    }
}

