/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossJsonListener;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.Network;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class EventHandler {
    @SubscribeEvent
    public static void applyProjectileDamageBoost(LivingHurtEvent event) {
        BossCapability cap;
        if (event.getSource().m_7639_() instanceof Player && event.getEntity() instanceof Mob) {
            BossCapability cap2 = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null);
            if (cap2 != null && cap2.isBoss()) {
                Network.instance.sendPacket((ServerPlayer)event.getSource().m_7639_(), new BossOverlayMessage(event.getEntity().m_142049_()));
            }
            return;
        }
        if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().m_7639_() != null && (cap = (BossCapability)event.getSource().m_7639_().getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss()) {
            event.setAmount((float)((double)(event.getAmount() + cap.getBossType().getCustomAttributeValueOrDefault("projectile_damage_bonus", 0.0f)) * (Double)BrutalBosses.config.getCommonConfig().globalDifficultyMultiplier.get()));
        }
    }

    @SubscribeEvent
    public static void playerClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)BrutalBosses.config.getCommonConfig().printChestLoottable.get()).booleanValue() || event.getWorld().m_5776_()) {
            return;
        }
        BlockEntity te = event.getEntity().f_19853_.m_7702_(event.getPos());
        if (te instanceof RandomizableContainerBlockEntity && ((RandomizableContainerBlockEntity)te).f_59605_ != null) {
            event.getPlayer().m_6352_((Component)new TextComponent("[Loottable: " + ((RandomizableContainerBlockEntity)te).f_59605_ + "]").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ((RandomizableContainerBlockEntity)te).f_59605_.toString()))), event.getPlayer().m_142081_());
        }
    }

    @SubscribeEvent
    public static void onBossDeath(LivingDeathEvent event) {
        BossCapability cap;
        if (!event.getEntity().f_19853_.m_5776_() && event.getSource().m_7639_() instanceof ServerPlayer && (cap = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss()) {
            int orbValue;
            for (int exp = cap.getBossType().getExperienceDrop(); exp > 0; exp -= orbValue) {
                orbValue = ExperienceOrb.m_20782_((int)exp);
                event.getEntity().f_19853_.m_7967_((Entity)new ExperienceOrb(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), orbValue));
            }
            int gearDropCount = Math.min(EquipmentSlot.values().length, (int)cap.getBossType().getCustomAttributeValueOrDefault("dropgear", 0.0f));
            for (int i = 0; i < gearDropCount; ++i) {
                ItemEntity itementity = new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getEntityLiving().m_6844_(EquipmentSlot.values()[i]));
                event.getEntity().f_19853_.m_7967_((Entity)itementity);
            }
            if (cap.getLootTable() != null) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)event.getEntity().f_19853_).m_78972_(LootContextParams.f_81460_, (Object)event.getEntity().m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)event.getSource().m_7639_()).m_78963_(((ServerPlayer)event.getSource().m_7639_()).m_36336_());
                LootTable loottable = event.getEntity().f_19853_.m_142572_().m_129898_().m_79217_(cap.getLootTable());
                List list = loottable.m_79129_(lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
                if (list.isEmpty()) {
                    return;
                }
                for (int i = 0; i < cap.getBossType().getItemLootCount(); ++i) {
                    ItemEntity itementity = new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), (ItemStack)list.get(BrutalBosses.rand.nextInt(list.size())));
                    event.getEntity().f_19853_.m_7967_((Entity)itementity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity.f_19853_.f_46443_ || BossTypeManager.instance.isValidBossEntity(entity)) {
            evt.addCapability(BossCapability.ID, (ICapabilityProvider)new BossCapability(entity));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)BossJsonListener.instance);
    }

    @SubscribeEvent
    public static void onTrack(PlayerEvent.StartTracking event) {
        BossCapability bossCapability;
        Entity entity = event.getTarget();
        Player Player2 = event.getPlayer();
        if (Player2 instanceof ServerPlayer && (bossCapability = (BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)) != null) {
            Network.instance.sendPacket((ServerPlayer)Player2, new BossCapMessage(bossCapability));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> Network.instance.sendPacket((ServerPlayer)event.getPlayer(), new BossTypeSyncMessage(BossTypeManager.instance.bosses.values())));
    }
}

