/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.aurelj.buriedbarrels.BuriedBarrelsMain;
import net.aurelj.buriedbarrels.structures.AbandonedMineshaftBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.DesertPyramidBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.EndCityBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.IglooBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.JungleTempleBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.PillagerOutpostBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.StrongholdBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.VillageBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.WoodlandMansionBuriedBarrelStructure;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BBStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"buriedbarrels");
    public static final RegistryObject<Structure<NoFeatureConfig>> DESERT_PYRAMID_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("desert_pyramid_buried_barrel", () -> new DesertPyramidBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> JUNGLE_TEMPLE_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("jungle_temple_buried_barrel", () -> new JungleTempleBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ABANDONED_MINESHAFT_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("abandoned_mineshaft_buried_barrel", () -> new AbandonedMineshaftBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> END_CITY_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("end_city_buried_barrel", () -> new EndCityBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> IGLOO_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("igloo_buried_barrel", () -> new IglooBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> PILLAGER_OUTPOST_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("pillager_outpost_buried_barrel", () -> new PillagerOutpostBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> WOODLAND_MANSION_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("woodland_mansion_buried_barrel", () -> new WoodlandMansionBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> VILLAGE_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("village_buried_barrel", () -> new VillageBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> STRONGHOLD_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("stronghold_buried_barrel", () -> new StrongholdBuriedBarrelStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        BBStructures.setupMapSpacingAndLand((Structure)DESERT_PYRAMID_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.desertPyramidBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.desertPyramidBuriedBarrelSpacing.get().intValue(), 736452617), false);
        BBStructures.setupMapSpacingAndLand((Structure)JUNGLE_TEMPLE_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.jungleTempleBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.jungleTempleBuriedBarrelSpacing.get().intValue(), 371615327), false);
        BBStructures.setupMapSpacingAndLand((Structure)ABANDONED_MINESHAFT_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.abandonedMineshaftBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.abandonedMineshaftBuriedBarrelSpacing.get().intValue(), 698573152), false);
        BBStructures.setupMapSpacingAndLand((Structure)END_CITY_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.endCityBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.endCityBuriedBarrelSpacing.get().intValue(), 121128617), false);
        BBStructures.setupMapSpacingAndLand((Structure)IGLOO_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.iglooBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.iglooBuriedBarrelSpacing.get().intValue(), 199281715), false);
        BBStructures.setupMapSpacingAndLand((Structure)PILLAGER_OUTPOST_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.pillagerOutpostBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.pillagerOutpostBuriedBarrelSpacing.get().intValue(), 847362162), false);
        BBStructures.setupMapSpacingAndLand((Structure)WOODLAND_MANSION_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.woodlandMansionBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.woodlandMansionBuriedBarrelSpacing.get().intValue(), 452644127), false);
        BBStructures.setupMapSpacingAndLand((Structure)VILLAGE_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.villageBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.villageBuriedBarrelSpacing.get().intValue(), 635141535), false);
        BBStructures.setupMapSpacingAndLand((Structure)STRONGHOLD_BURIED_BARREL.get(), new StructureSeparationSettings(5 + BuriedBarrelsMain.BBConfig.strongholdBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.strongholdBuriedBarrelSpacing.get().intValue(), 352414216), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

