/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels;

import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import net.aurelj.buriedbarrels.BBConfiguredStructures;
import net.aurelj.buriedbarrels.BBStructures;
import net.aurelj.buriedbarrels.config.BBConfig;
import net.aurelj.buriedbarrels.config.ConfigHelper;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="buriedbarrels")
public class BuriedBarrelsMain {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "buriedbarrels";
    public static BBConfig.BBConfigValues BBConfig = null;
    private static Method GETCODEC_METHOD;

    public BuriedBarrelsMain() {
        BBConfig = ConfigHelper.register(ModConfig.Type.COMMON, BBConfig.BBConfigValues::new, "buried-barrels-common.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BBStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BBStructures.setupStructures();
            BBConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.SANDY) && types.contains(BiomeDictionary.Type.DRY) && !types.contains(BiomeDictionary.Type.MESA) && BuriedBarrelsMain.BBConfig.desertPyramidBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_DESERT_PYRAMID_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.JUNGLE) && BuriedBarrelsMain.BBConfig.jungleTempleBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_JUNGLE_TEMPLE_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && BuriedBarrelsMain.BBConfig.abandonedMineshaftBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_ABANDONED_MINESHAFT_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.END) && BuriedBarrelsMain.BBConfig.endCityBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_END_CITY_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.SNOWY) && BuriedBarrelsMain.BBConfig.iglooBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_IGLOO_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && BuriedBarrelsMain.BBConfig.pillagerOutpostBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_PILLAGER_OUTPOST_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.FOREST) && BuriedBarrelsMain.BBConfig.woodlandMansionBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_WOODLAND_MANSION_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && BuriedBarrelsMain.BBConfig.villageBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_VILLAGE_BURIED_BARREL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && BuriedBarrelsMain.BBConfig.strongholdBuriedBarrelGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> BBConfiguredStructures.CONFIGURED_STRONGHOLD_BURIED_BARREL);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(BBStructures.DESERT_PYRAMID_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.DESERT_PYRAMID_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.JUNGLE_TEMPLE_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.JUNGLE_TEMPLE_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.ABANDONED_MINESHAFT_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.ABANDONED_MINESHAFT_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.END_CITY_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.END_CITY_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.IGLOO_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.IGLOO_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.PILLAGER_OUTPOST_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.PILLAGER_OUTPOST_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.WOODLAND_MANSION_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.WOODLAND_MANSION_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.VILLAGE_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.VILLAGE_BURIED_BARREL.get()));
            tempMap.putIfAbsent(BBStructures.STRONGHOLD_BURIED_BARREL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)BBStructures.STRONGHOLD_BURIED_BARREL.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static ResourceLocation getId(String path) {
        return new ResourceLocation(MODID, path);
    }
}

