/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.aurelj.buriedbarrels.BuriedBarrelsMain;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buriedbarrels")
public final class LootInjector {
    private LootInjector() {
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Tables.get(event.getName()).ifPresent(injectorName -> {
            BuriedBarrelsMain.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
            event.getTable().addPool(LootPool.func_216096_a().name("buriedbarrels_injected").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)injectorName)).func_216044_b());
        });
    }

    public static final class Tables {
        private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
        public static final ResourceLocation CHESTS_ABANDONED_MINESHAFT = Tables.inject(LootTables.field_186424_f);
        public static final ResourceLocation CHESTS_DESERT_PYRAMID = Tables.inject(LootTables.field_186429_k);
        public static final ResourceLocation CHESTS_JUNGLE_TEMPLE = Tables.inject(LootTables.field_186430_l);
        public static final ResourceLocation CHESTS_END_CITY_TREASURE = Tables.inject(LootTables.field_186421_c);
        public static final ResourceLocation CHESTS_IGLOO_CHEST = Tables.inject(LootTables.field_186431_m);
        public static final ResourceLocation CHESTS_PILLAGER_OUTPOST = Tables.inject(LootTables.field_215813_K);
        public static final ResourceLocation CHESTS_WOODLAND_MANSION = Tables.inject(LootTables.field_191192_o);
        public static final ResourceLocation CHESTS_VILLAGE_WEAPONSMITH = Tables.inject(LootTables.field_215814_e);
        public static final ResourceLocation CHESTS_STRONGHOLD_CORRIDOR = Tables.inject(LootTables.field_186428_j);
        public static final ResourceLocation CHESTS_ILLAGER_FORT = Tables.inject(ResourceLocation.func_208304_a((String)"dungeons_arise:illager_fort/illager_fort_treasure"));
        public static final ResourceLocation CHESTS_STRONGHOLD_YUNGS = Tables.inject(ResourceLocation.func_208304_a((String)"betterstrongholds:chests/treasure"));
        public static final ResourceLocation CHESTS_DESERT_YUNGEXTRAS = Tables.inject(ResourceLocation.func_208304_a((String)"yungextras:chests/desert/ruins"));
        public static final ResourceLocation CHESTS_PILLAGER_OUTPOST_SNOWY = Tables.inject(ResourceLocation.func_208304_a((String)"repurposed_structures:chests/outposts/snowy"));
        public static final ResourceLocation CHESTS_PILLAGER_OUTPOST_DESERT = Tables.inject(ResourceLocation.func_208304_a((String)"repurposed_structures:chests/outposts/desert"));

        private Tables() {
        }

        public static Collection<ResourceLocation> getValues() {
            return MAP.values();
        }

        public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
            return Optional.ofNullable(MAP.get(lootTable));
        }

        private static ResourceLocation inject(ResourceLocation lootTable) {
            ResourceLocation ret = BuriedBarrelsMain.getId("inject/" + lootTable.func_110623_a());
            MAP.put(lootTable, ret);
            return ret;
        }
    }
}

