/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.aurelj.buriedbarrels.BuriedBarrelsMain;
import net.aurelj.buriedbarrels.structures.AbandonedMineshaftBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.CommonHiddenBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.DesertPyramidBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.EndCityBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.IglooBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.JungleTempleBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.PillagerOutpostBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.StrongholdBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.VillageBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.WoodlandMansionBuriedBarrelStructure;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BBStructures {
    public static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"buriedbarrels");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> ABANDONED_MINESHAFT_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("abandoned_mineshaft_buried_barrel", () -> new AbandonedMineshaftBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> DESERT_PYRAMID_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("desert_pyramid_buried_barrel", () -> new DesertPyramidBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> END_CITY_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("end_city_buried_barrel", () -> new EndCityBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> IGLOO_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("igloo_buried_barrel", () -> new IglooBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> JUNGLE_TEMPLE_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("jungle_temple_buried_barrel", () -> new JungleTempleBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> PILLAGER_OUTPOST_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("pillager_outpost_buried_barrel", () -> new PillagerOutpostBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> STRONGHOLD_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("stronghold_buried_barrel", () -> new StrongholdBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> VILLAGE_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("village_buried_barrel", () -> new VillageBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> WOODLAND_MANSION_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("woodland_mansion_buried_barrel", () -> new WoodlandMansionBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> COMMON_HIDDEN_BURIED_BARREL = DEFERRED_REGISTRY_STRUCTURE.register("common_hidden_buried_barrel", () -> new CommonHiddenBuriedBarrelStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    public static void setupStructures() {
        BBStructures.setupMapSpacingAndLand((StructureFeature)DESERT_PYRAMID_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.desertPyramidBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.desertPyramidBuriedBarrelSpacing.get().intValue(), 736452617), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)JUNGLE_TEMPLE_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.jungleTempleBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.jungleTempleBuriedBarrelSpacing.get().intValue(), 371615327), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)ABANDONED_MINESHAFT_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.abandonedMineshaftBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.abandonedMineshaftBuriedBarrelSpacing.get().intValue(), 698573152), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)END_CITY_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.endCityBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.endCityBuriedBarrelSpacing.get().intValue(), 121128617), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)IGLOO_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.iglooBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.iglooBuriedBarrelSpacing.get().intValue(), 199281715), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)PILLAGER_OUTPOST_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.pillagerOutpostBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.pillagerOutpostBuriedBarrelSpacing.get().intValue(), 847362162), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)WOODLAND_MANSION_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.woodlandMansionBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.woodlandMansionBuriedBarrelSpacing.get().intValue(), 452644127), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)VILLAGE_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.villageBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.villageBuriedBarrelSpacing.get().intValue(), 635141535), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)STRONGHOLD_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.strongholdBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.strongholdBuriedBarrelSpacing.get().intValue(), 352414216), false);
        BBStructures.setupMapSpacingAndLand((StructureFeature)COMMON_HIDDEN_BURIED_BARREL.get(), new StructureFeatureConfiguration(5 + BuriedBarrelsMain.BBConfig.commonHiddenBuriedBarrelSpacing.get(), BuriedBarrelsMain.BBConfig.commonHiddenBuriedBarrelSpacing.get().intValue(), 885528311), false);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureFeatureConfiguration, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureFeatureConfiguration).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureFeatureConfiguration);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, structureFeatureConfiguration);
            }
        });
    }
}

