/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.aurelj.buriedbarrels.BBConfiguredStructures;
import net.aurelj.buriedbarrels.BBStructures;
import net.aurelj.buriedbarrels.config.BBConfig;
import net.aurelj.buriedbarrels.config.ConfigHelper;
import net.aurelj.buriedbarrels.structures.AbandonedMineshaftBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.CommonHiddenBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.DesertPyramidBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.EndCityBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.IglooBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.JungleTempleBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.PillagerOutpostBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.StrongholdBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.VillageBuriedBarrelStructure;
import net.aurelj.buriedbarrels.structures.WoodlandMansionBuriedBarrelStructure;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="buriedbarrels")
public class BuriedBarrelsMain {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "buriedbarrels";
    public static BBConfig.BBConfigValues BBConfig = null;
    private static Method GETCODEC_METHOD;

    public BuriedBarrelsMain() {
        BBConfig = ConfigHelper.register(ModConfig.Type.COMMON, BBConfig.BBConfigValues::new, "buried-barrels-common.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BBStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.NORMAL, AbandonedMineshaftBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, DesertPyramidBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, EndCityBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, IglooBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, JungleTempleBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, PillagerOutpostBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, StrongholdBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, VillageBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, WoodlandMansionBuriedBarrelStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, CommonHiddenBuriedBarrelStructure::setupStructureSpawns);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BBStructures.setupStructures();
            BBConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            Biome.BiomeCategory biomeCategory;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap BBStructureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.abandonedMineshaftBuriedBarrelGenerates.get().booleanValue()) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_ABANDONED_MINESHAFT_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.desertPyramidBuriedBarrelGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.DESERT) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_DESERT_PYRAMID_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory != Biome.BiomeCategory.THEEND || !BuriedBarrelsMain.BBConfig.endCityBuriedBarrelGenerates.get().booleanValue()) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_END_CITY_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.iglooBuriedBarrelGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.ICY && biomeCategory != Biome.BiomeCategory.EXTREME_HILLS) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_IGLOO_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.jungleTempleBuriedBarrelGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.JUNGLE) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_JUNGLE_TEMPLE_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.pillagerOutpostBuriedBarrelGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS && biomeCategory != Biome.BiomeCategory.DESERT) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_PILLAGER_OUTPOST_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.strongholdBuriedBarrelGenerates.get().booleanValue()) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_STRONGHOLD_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.villageBuriedBarrelGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_VILLAGE_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.woodlandMansionBuriedBarrelGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.FOREST && biomeCategory != Biome.BiomeCategory.SWAMP) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_WOODLAND_MANSION_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !BuriedBarrelsMain.BBConfig.commonHiddenBuriedBarrelGenerates.get().booleanValue()) continue;
                BuriedBarrelsMain.associateBiomeToConfiguredStructure(BBStructureToMultiMap, BBConfiguredStructures.CONFIGURED_COMMON_HIDDEN_BURIED_BARREL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !BBStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            BBStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)BBStructures.DESERT_PYRAMID_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.DESERT_PYRAMID_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.JUNGLE_TEMPLE_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.JUNGLE_TEMPLE_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.ABANDONED_MINESHAFT_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.ABANDONED_MINESHAFT_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.END_CITY_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.END_CITY_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.IGLOO_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.IGLOO_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.PILLAGER_OUTPOST_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.PILLAGER_OUTPOST_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.WOODLAND_MANSION_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.WOODLAND_MANSION_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.VILLAGE_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.VILLAGE_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.STRONGHOLD_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.STRONGHOLD_BURIED_BARREL.get()));
            tempMap.putIfAbsent((StructureFeature)BBStructures.COMMON_HIDDEN_BURIED_BARREL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)BBStructures.COMMON_HIDDEN_BURIED_BARREL.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    public static ResourceLocation getId(String path) {
        return new ResourceLocation(MODID, path);
    }
}

