/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.aurelj.buriedbarrels.BuriedBarrelsMain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buriedbarrels")
public final class LootInjector {
    private LootInjector() {
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Tables.get(event.getName()).ifPresent(injectorName -> {
            BuriedBarrelsMain.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
            event.getTable().addPool(LootPool.m_79043_().name("buriedbarrels_injected").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)injectorName)).m_79082_());
        });
    }

    public static final class Tables {
        private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
        public static final ResourceLocation CHESTS_ABANDONED_MINESHAFT = Tables.inject(BuiltInLootTables.f_78759_);
        public static final ResourceLocation CHESTS_DESERT_PYRAMID = Tables.inject(BuiltInLootTables.f_78764_);
        public static final ResourceLocation CHESTS_JUNGLE_TEMPLE = Tables.inject(BuiltInLootTables.f_78686_);
        public static final ResourceLocation CHESTS_END_CITY_TREASURE = Tables.inject(BuiltInLootTables.f_78741_);
        public static final ResourceLocation CHESTS_IGLOO_CHEST = Tables.inject(BuiltInLootTables.f_78688_);
        public static final ResourceLocation CHESTS_PILLAGER_OUTPOST = Tables.inject(BuiltInLootTables.f_78696_);
        public static final ResourceLocation CHESTS_WOODLAND_MANSION = Tables.inject(BuiltInLootTables.f_78689_);
        public static final ResourceLocation CHESTS_VILLAGE_WEAPONSMITH = Tables.inject(BuiltInLootTables.f_78743_);
        public static final ResourceLocation CHESTS_STRONGHOLD_CORRIDOR = Tables.inject(BuiltInLootTables.f_78763_);
        public static final ResourceLocation CHESTS_ILLAGER_FORT = Tables.inject(ResourceLocation.m_135820_((String)"dungeons_arise:illager_fort/illager_fort_treasure"));
        public static final ResourceLocation CHESTS_STRONGHOLD_YUNGS = Tables.inject(ResourceLocation.m_135820_((String)"betterstrongholds:chests/treasure"));
        public static final ResourceLocation CHESTS_DESERT_YUNGEXTRAS = Tables.inject(ResourceLocation.m_135820_((String)"yungextras:chests/desert/ruins"));
        public static final ResourceLocation CHESTS_PILLAGER_OUTPOST_SNOWY = Tables.inject(ResourceLocation.m_135820_((String)"repurposed_structures:chests/outposts/snowy"));
        public static final ResourceLocation CHESTS_PILLAGER_OUTPOST_DESERT = Tables.inject(ResourceLocation.m_135820_((String)"repurposed_structures:chests/outposts/desert"));

        private Tables() {
        }

        public static Collection<ResourceLocation> getValues() {
            return MAP.values();
        }

        public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
            return Optional.ofNullable(MAP.get(lootTable));
        }

        private static ResourceLocation inject(ResourceLocation lootTable) {
            ResourceLocation ret = BuriedBarrelsMain.getId("inject/" + lootTable.m_135815_());
            MAP.put(lootTable, ret);
            return ret;
        }
    }
}

