/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.buriedbarrels.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class CommonHiddenBuriedBarrelStructure<C extends JigsawConfiguration>
extends StructureFeature<JigsawConfiguration> {
    public CommonHiddenBuriedBarrelStructure(Codec<JigsawConfiguration> codec) {
        super(JigsawConfiguration.f_67756_, CommonHiddenBuriedBarrelStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        BlockPos blockPos = new BlockPos(context.f_197355_().m_151390_() - 8, -1, context.f_197355_().m_151393_() - 8);
        int landHeight = context.f_197352_().m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(blockPos.m_123341_(), blockPos.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        return topBlock.m_60819_().m_76178_() && landHeight > 10;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!CommonHiddenBuriedBarrelStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = new BlockPos(context.f_197355_().m_151390_() - 8, -1, context.f_197355_().m_151393_() - 8);
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)true);
        return structurePiecesGenerator;
    }
}

