/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.hedgehog.client.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.hedgehog.entities.HedgehogEntity;

@OnlyIn(value=Dist.CLIENT)
public class HedgehogModel<T extends HedgehogEntity>
extends AgeableListModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart snout;
    private final ModelPart spines_top1;
    private final ModelPart spines_top2;
    private final ModelPart spines_top3;
    private final ModelPart spines_right1;
    private final ModelPart spines_right2;
    private final ModelPart spines_right3;
    private final ModelPart spines_left1;
    private final ModelPart spines_left2;
    private final ModelPart spines_left3;
    private final ModelPart left_ear;
    private final ModelPart right_ear;
    private final ModelPart right_foot;
    private final ModelPart left_foot;
    private final ModelPart left_hand;
    private final ModelPart right_hand;

    public HedgehogModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.right_foot = root.m_171324_("right_foot");
        this.left_foot = root.m_171324_("left_foot");
        this.left_hand = root.m_171324_("left_hand");
        this.right_hand = root.m_171324_("right_hand");
        this.snout = this.body.m_171324_("snout");
        this.spines_top1 = this.body.m_171324_("spines_top1");
        this.spines_top2 = this.body.m_171324_("spines_top2");
        this.spines_top3 = this.body.m_171324_("spines_top3");
        this.spines_right1 = this.body.m_171324_("spines_right1");
        this.spines_right2 = this.body.m_171324_("spines_right2");
        this.spines_right3 = this.body.m_171324_("spines_right3");
        this.spines_left1 = this.body.m_171324_("spines_left1");
        this.spines_left2 = this.body.m_171324_("spines_left2");
        this.spines_left3 = this.body.m_171324_("spines_left3");
        this.left_ear = this.body.m_171324_("left_ear");
        this.right_ear = this.body.m_171324_("right_ear");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171555_(false).m_171488_(-3.0f, -3.0f, -4.5f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition snout = body.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171555_(false).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spines_top1 = body.m_171599_("spines_top1", CubeListBuilder.m_171558_().m_171514_(21, 5).m_171555_(false).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-2.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition spines_top2 = body.m_171599_("spines_top2", CubeListBuilder.m_171558_().m_171514_(21, 8).m_171555_(false).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition spines_top3 = body.m_171599_("spines_top3", CubeListBuilder.m_171558_().m_171514_(21, 5).m_171555_(false).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)2.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition spines_right1 = body.m_171599_("spines_right1", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171555_(true).m_171488_(-2.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.5f, (float)-2.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition spines_right2 = body.m_171599_("spines_right2", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171555_(true).m_171488_(-2.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition spines_right3 = body.m_171599_("spines_right3", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171555_(true).m_171488_(-2.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.5f, (float)2.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition spines_left1 = body.m_171599_("spines_left1", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171555_(false).m_171488_(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-0.5f, (float)-2.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition spines_left2 = body.m_171599_("spines_left2", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171555_(false).m_171488_(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition spines_left3 = body.m_171599_("spines_left3", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171555_(false).m_171488_(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-0.5f, (float)2.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition left_ear = body.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171555_(true).m_171488_(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition right_ear = body.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171555_(false).m_171488_(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition right_foot = root.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171555_(false).m_171488_(-0.5f, 0.0f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)23.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_foot = root.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171555_(false).m_171488_(-0.5f, 0.0f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)23.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_hand = root.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171555_(false).m_171488_(-0.5f, 0.0f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)23.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_hand = root.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171555_(false).m_171488_(-0.5f, 0.0f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)23.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)32, (int)16);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float speed = 2.0f;
        float degree = 1.5f;
        if (!entity.m_20069_()) {
            this.body.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * 0.3f * limbDistance;
            this.body.f_104204_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.2f)) * degree * 0.3f * limbDistance;
            this.body.f_104201_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * 0.75f * limbDistance + 20.025f;
            this.left_ear.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance - 0.8f;
            this.right_ear.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * -0.4f * limbDistance + 0.8f;
            this.snout.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.6f)) * degree * 0.2f * 0.25f;
            this.left_hand.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * 0.8f * limbDistance;
            this.right_hand.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * -0.8f * limbDistance;
            this.left_hand.f_104202_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.4f)) * degree * 0.5f * limbDistance - 2.0f;
            this.right_hand.f_104202_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.4f)) * degree * -0.5f * limbDistance - 2.0f;
            this.left_foot.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * -0.8f * limbDistance;
            this.right_foot.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * 0.8f * limbDistance;
            this.left_foot.f_104202_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.4f)) * degree * -0.5f * limbDistance + 1.5f;
            this.right_foot.f_104202_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.4f)) * degree * 0.5f * limbDistance + 1.5f;
            this.spines_top1.f_104203_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance - 1.0f;
            this.spines_top2.f_104203_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * -0.4f * limbDistance - 1.0f;
            this.spines_top3.f_104203_ = Mth.m_14089_((float)(-4.0f + limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance - 1.0f;
            this.spines_right1.f_104204_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance + 1.0f;
            this.spines_right2.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * -0.4f * limbDistance + 1.0f;
            this.spines_right3.f_104204_ = Mth.m_14089_((float)(-4.0f + limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance + 1.0f;
            this.spines_left1.f_104204_ = Mth.m_14089_((float)(-1.0f + limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance - 1.0f;
            this.spines_left2.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 0.2f)) * degree * -0.4f * limbDistance - 1.0f;
            this.spines_left3.f_104204_ = Mth.m_14089_((float)(-4.0f + limbAngle * speed * 0.2f)) * degree * 0.4f * limbDistance - 1.0f;
            this.left_hand.f_104201_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * 0.5f * limbDistance + 23.0f;
            this.right_hand.f_104201_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * -0.5f * limbDistance + 23.0f;
            this.right_foot.f_104201_ = Mth.m_14089_((float)(limbAngle * speed * 0.4f)) * degree * 0.5f * limbDistance + 23.005f;
            this.left_foot.f_104201_ = Mth.m_14089_((float)(-3.0f + limbAngle * speed * 0.4f)) * degree * 0.5f * limbDistance + 23.005f;
            this.left_hand.f_104203_ = 0.0f;
            this.right_hand.f_104203_ = 0.0f;
            this.right_foot.f_104203_ = 0.0f;
            this.left_foot.f_104203_ = 0.0f;
        } else {
            this.left_hand.f_104203_ = 2.2f;
            this.right_hand.f_104203_ = 2.2f;
            this.right_foot.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.1f)) * degree * 0.8f * 0.25f + 0.8f;
            this.left_foot.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.1f)) * degree * -0.8f * 0.25f + 0.8f;
            this.snout.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.6f)) * degree * 0.2f * 0.25f;
            this.body.f_104205_ = Mth.m_14089_((float)(animationProgress * speed * 0.05f)) * degree * 0.3f * 0.25f;
            this.spines_top1.f_104203_ = Mth.m_14089_((float)(-1.0f + animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f - 1.0f;
            this.spines_top2.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * -0.4f * 0.25f - 1.0f;
            this.spines_top3.f_104203_ = Mth.m_14089_((float)(-4.0f + animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f - 1.0f;
            this.spines_right1.f_104204_ = Mth.m_14089_((float)(-1.0f + animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f + 1.0f;
            this.spines_right2.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * -0.4f * 0.25f + 1.0f;
            this.spines_right3.f_104204_ = Mth.m_14089_((float)(-4.0f + animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f + 1.0f;
            this.spines_left1.f_104204_ = Mth.m_14089_((float)(-1.0f + animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f - 1.0f;
            this.spines_left2.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.2f)) * degree * -0.4f * 0.25f - 1.0f;
            this.spines_left3.f_104204_ = Mth.m_14089_((float)(-4.0f + animationProgress * speed * 0.2f)) * degree * 0.4f * 0.25f - 1.0f;
            this.body.f_104204_ = 0.0f;
            this.body.f_104201_ = 20.0f;
            this.left_hand.f_104201_ = 23.0f;
            this.right_hand.f_104201_ = 23.0f;
            this.right_foot.f_104201_ = 23.0f;
            this.left_foot.f_104201_ = 23.0f;
            this.left_hand.f_104204_ = 0.0f;
            this.right_hand.f_104204_ = 0.0f;
            this.left_hand.f_104202_ = -2.0f;
            this.right_hand.f_104202_ = -2.0f;
            this.left_foot.f_104204_ = 0.0f;
            this.right_foot.f_104204_ = 0.0f;
            this.left_foot.f_104202_ = 1.5f;
            this.right_foot.f_104202_ = 1.5f;
        }
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.left_hand, (Object)this.right_hand, (Object)this.left_foot, (Object)this.right_foot);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }
}

