/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.hedgehog.entities;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogAfraidOfSkullGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogBegGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogBreedGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogEatSpiderEyeGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogFollowOwnerGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogLookAtPlayerGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogMeleeAttackGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogNearestAttackableTargetGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogOwnerHurtByTargetGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogOwnerHurtTargetGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogPanicGoal;
import net.orcinus.hedgehog.entities.ai.hedgehog.HedgehogRandomLookAroundGal;
import net.orcinus.hedgehog.init.HedgehogEntities;
import net.orcinus.hedgehog.init.HedgehogItems;
import net.orcinus.hedgehog.init.HedgehogSoundEvents;
import org.jetbrains.annotations.Nullable;

public class HedgehogEntity
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BAND_COLOR = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SCARED_TICKS = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> POTION_TICKS = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ASSISTANCE_TICKS = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ANOINTED = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_INSTANTANEOUS = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_INTERESTED = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EFFECT_COLOR = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int snifingTicks;
    @Nullable
    private UUID persistentAngerTarget;
    private Potion potion = Potions.f_43598_;
    private static final Map<DyeColor, Item> ITEM_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Items.f_41870_);
        map.put(DyeColor.ORANGE, Items.f_41871_);
        map.put(DyeColor.MAGENTA, Items.f_41872_);
        map.put(DyeColor.LIGHT_BLUE, Items.f_41873_);
        map.put(DyeColor.YELLOW, Items.f_41874_);
        map.put(DyeColor.LIME, Items.f_41875_);
        map.put(DyeColor.PINK, Items.f_41876_);
        map.put(DyeColor.GRAY, Items.f_41877_);
        map.put(DyeColor.LIGHT_GRAY, Items.f_41878_);
        map.put(DyeColor.CYAN, Items.f_41932_);
        map.put(DyeColor.PURPLE, Items.f_41933_);
        map.put(DyeColor.BLUE, Items.f_41934_);
        map.put(DyeColor.BROWN, Items.f_41935_);
        map.put(DyeColor.GREEN, Items.f_41936_);
        map.put(DyeColor.RED, Items.f_41937_);
        map.put(DyeColor.BLACK, Items.f_41938_);
    });

    public HedgehogEntity(EntityType<? extends HedgehogEntity> type, Level world) {
        super(type, world);
        this.f_21365_ = new HedgehogLookControl(this);
        this.f_21342_ = new HedgehogMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HedgehogAfraidOfSkullGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HedgehogPanicGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new HedgehogEatSpiderEyeGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new HedgehogMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new HedgehogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new HedgehogBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new HedgehogBegGoal(this, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new HedgehogLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new HedgehogRandomLookAroundGal(this));
        this.f_21346_.m_25352_(1, (Goal)new HedgehogOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HedgehogOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Fox.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new HedgehogNearestAttackableTargetGoal<Spider>(this, Spider.class, false));
        this.f_21346_.m_25352_(5, new HedgehogNearestAttackableTargetGoal<CaveSpider>(this, CaveSpider.class, false));
        this.f_21346_.m_25352_(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BAND_COLOR, (Object)-1);
        this.f_19804_.m_135372_(POTION_TICKS, (Object)0);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(SCARED_TICKS, (Object)0);
        this.f_19804_.m_135372_(ASSISTANCE_TICKS, (Object)0);
        this.f_19804_.m_135372_(EFFECT_COLOR, (Object)0);
        this.f_19804_.m_135372_(IS_INTERESTED, (Object)false);
        this.f_19804_.m_135372_(IS_INSTANTANEOUS, (Object)false);
        this.f_19804_.m_135372_(ANOINTED, (Object)false);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (!source.m_19387_() && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!source.m_19372_()) {
                livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f);
            }
        }
        return super.m_6469_(source, amount);
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return (SoundEvent)HedgehogSoundEvents.ENTITY_HEDGEHOG_EATING.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getScaredTicks() > 0) {
            return (SoundEvent)HedgehogSoundEvents.ENTITY_HEDGEHOG_SCARED.get();
        }
        return (SoundEvent)HedgehogSoundEvents.ENTITY_HEDGEHOG_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)HedgehogSoundEvents.ENTITY_HEDGEHOG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)HedgehogSoundEvents.ENTITY_HEDGEHOG_DEATH.get();
    }

    public DyeColor getBandColor() {
        int i = (Integer)this.f_19804_.m_135370_(BAND_COLOR);
        return i == -1 ? null : DyeColor.m_41053_((int)i);
    }

    public void setBandColor(DyeColor color) {
        this.f_19804_.m_135381_(BAND_COLOR, (Object)(color == null ? -1 : color.m_41060_()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        tag.m_128405_("EffectColor", this.getEffectColor());
        tag.m_128405_("ScaredTicks", this.getScaredTicks());
        tag.m_128405_("PotionTicks", this.getPotionTicks());
        tag.m_128405_("AssistanceTicks", this.getAssistanceTicks());
        tag.m_128379_("instantaneous", this.isInstantaneous());
        tag.m_128379_("Anointed", this.isAnointed());
        if (this.getBandColor() != null) {
            tag.m_128344_("BandColor", (byte)this.getBandColor().m_41060_());
        }
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setEffectColor(tag.m_128451_("EffectColor"));
        this.setScaredTicks(tag.m_128451_("ScaredTicks"));
        this.setPotionTicks(tag.m_128451_("PotionTicks"));
        this.setAssistanceTicks(tag.m_128451_("AssistanceTicks"));
        this.setAnointed(tag.m_128471_("Anointed"));
        this.setIsInstantaneous(tag.m_128471_("Instantaneous"));
        this.m_147285_(this.f_19853_, tag);
        this.setPotion(PotionUtils.m_43577_((CompoundTag)tag));
        if (tag.m_128425_("BandColor", 99)) {
            this.setBandColor(DyeColor.m_41053_((int)tag.m_128451_("BandColor")));
        }
    }

    public int getEffectColor() {
        return (Integer)this.f_19804_.m_135370_(EFFECT_COLOR);
    }

    public void setEffectColor(int effectColor) {
        this.f_19804_.m_135381_(EFFECT_COLOR, (Object)effectColor);
    }

    public int getAssistanceTicks() {
        return (Integer)this.f_19804_.m_135370_(ASSISTANCE_TICKS);
    }

    public void setAssistanceTicks(int assistanceTicks) {
        this.f_19804_.m_135381_(ASSISTANCE_TICKS, (Object)assistanceTicks);
    }

    public boolean isInstantaneous() {
        return (Boolean)this.f_19804_.m_135370_(IS_INSTANTANEOUS);
    }

    public void setIsInstantaneous(boolean instantaneous) {
        this.f_19804_.m_135381_(IS_INSTANTANEOUS, (Object)instantaneous);
    }

    public boolean hasPotion() {
        return this.potion != Potions.f_43598_;
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
    }

    public boolean isAnointed() {
        return (Boolean)this.f_19804_.m_135370_(ANOINTED);
    }

    public void setAnointed(boolean anointed) {
        this.f_19804_.m_135381_(ANOINTED, (Object)anointed);
    }

    public int getSnifingTicks() {
        return this.snifingTicks;
    }

    public void setSnifingTicks(int snifingTicks) {
        this.snifingTicks = snifingTicks;
    }

    public int getPotionTicks() {
        return (Integer)this.f_19804_.m_135370_(POTION_TICKS);
    }

    public void setPotionTicks(int potionTick) {
        this.f_19804_.m_135381_(POTION_TICKS, (Object)potionTick);
    }

    public int getScaredTicks() {
        return (Integer)this.f_19804_.m_135370_(SCARED_TICKS);
    }

    public void setScaredTicks(int scaredTicks) {
        this.f_19804_.m_135381_(SCARED_TICKS, (Object)scaredTicks);
    }

    public void setIsInterested(boolean isInterested) {
        this.f_19804_.m_135381_(IS_INTERESTED, (Object)isInterested);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(IS_INTERESTED);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        if (effect == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.hasPotion() && (this.getPotionTicks() > 0 || this.isInstantaneous())) {
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        if (this.isAnointed()) {
            this.f_19853_.m_7605_((Entity)this, (byte)9);
        }
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        List foxes = this.f_19853_.m_45976_(Fox.class, this.m_142469_().m_82400_(3.0));
        List closestLivings = this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_(0.6), entity -> {
            if (entity instanceof Player) {
                return !((Player)entity).m_150110_().f_35937_;
            }
            return !entity.m_5833_();
        });
        for (Fox nearbyFoxes : foxes) {
            if (!nearbyFoxes.m_6084_()) continue;
            this.setScaredTicks(300);
        }
        for (LivingEntity nearbyMobs : closestLivings) {
            if (!nearbyMobs.m_6084_() || this.getScaredTicks() <= 0 || nearbyMobs instanceof HedgehogEntity || nearbyMobs instanceof TamableAnimal && ((TamableAnimal)nearbyMobs).m_21824_()) continue;
            if (this.hasPotion() && (this.getPotionTicks() > 0 || this.isInstantaneous()) && !this.f_19853_.m_5776_()) {
                for (MobEffectInstance mobEffectInstance : this.potion.m_43488_()) {
                    MobEffect effect = mobEffectInstance.m_19544_();
                    if (!nearbyMobs.m_7301_(mobEffectInstance) || nearbyMobs.m_21023_(effect)) continue;
                    if (effect.m_8093_() && this.isInstantaneous()) {
                        this.setIsInstantaneous(false);
                        effect.m_19461_(null, null, nearbyMobs, mobEffectInstance.m_19564_(), 1.0);
                        continue;
                    }
                    nearbyMobs.m_7292_(mobEffectInstance);
                }
            }
            nearbyMobs.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
        }
        if (this.getAssistanceTicks() > 0) {
            this.setAssistanceTicks(this.getAssistanceTicks() - 1);
            this.setScaredTicks(0);
        }
        if (this.getPotionTicks() > 0) {
            this.setPotionTicks(this.getPotionTicks() - 1);
        }
        if (!this.isInstantaneous() && this.getPotionTicks() == 0 && this.potion != Potions.f_43598_) {
            this.setPotion(Potions.f_43598_);
        }
        if (this.f_19796_.nextInt(15) == 0 && this.f_19796_.nextBoolean()) {
            this.setSnifingTicks(20);
        }
        if (this.getSnifingTicks() > 0) {
            this.setSnifingTicks(this.getSnifingTicks() - 1);
        }
        if (this.getScaredTicks() > 0) {
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setScaredTicks(this.getScaredTicks() - 1);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || stack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (stack.m_150930_(Items.f_42455_)) {
            this.m_6074_();
            ItemStack stack1 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42446_.m_7968_());
            player.m_21008_(hand, stack1);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42591_) && this.getScaredTicks() == 0 && !this.m_6162_() && !this.hasPotion() && !this.isAnointed()) {
            for (int i = 0; i < UniformInt.m_146622_((int)40, (int)80).m_142270_(this.f_19796_); ++i) {
                Vec3 vec3 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.nextFloat() - 0.5) * 0.1);
                vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                double d0 = (double)(-this.f_19796_.nextFloat()) * 0.6 - 0.3;
                Vec3 vec31 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.8, d0, 1.0 + ((double)this.f_19796_.nextFloat() - 0.5) * 0.4);
                vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42591_)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.5);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.setAnointed(true);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6162_() && stack.m_41720_() instanceof PotionItem && this.isAnointed() && !this.hasPotion()) {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            List instance = potion.m_43488_();
            for (MobEffectInstance effectInstance : instance) {
                if (!effectInstance.m_19544_().m_8093_()) {
                    this.setPotionTicks(effectInstance.m_19557_());
                } else {
                    this.setIsInstantaneous(true);
                }
                this.setEffectColor(effectInstance.m_19544_().m_19484_());
            }
            this.setPotion(potion);
            this.setAnointed(false);
            stack.m_41774_(1);
            if (!player.m_150110_().f_35937_) {
                if (stack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_))) {
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42590_), false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                if (stack.m_150930_((Item)HedgehogItems.KIWI.get())) {
                    this.setAssistanceTicks(1200);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(item.m_41473_().m_38744_());
                this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                return InteractionResult.SUCCESS;
            }
            for (DyeColor dyeColor : ITEM_BY_DYE.keySet()) {
                Item dyeItem = ITEM_BY_DYE.get(dyeColor);
                if (stack.m_41720_() != dyeItem) continue;
                this.setBandColor(dyeColor);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(player, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            DyeColor dyecolor = ((DyeItem)item).m_41089_();
            if (dyecolor != this.getBandColor()) {
                if (this.getBandColor().m_41060_() != -1) {
                    this.setBandColor(dyecolor);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if ((stack.m_150930_((Item)HedgehogItems.KIWI.get()) || stack.m_150930_(Items.f_42410_)) && !this.m_21660_() && this.getScaredTicks() == 0) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.f_19796_.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7822_(byte id) {
        boolean flag;
        int i;
        super.m_7822_(id);
        if (id == 8 && (i = this.getEffectColor()) > 0 && (flag = this.m_20145_() ? this.f_19796_.nextInt(15) == 0 : this.f_19796_.nextBoolean())) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
        }
        if (id == 9 && this.f_19796_.nextInt(15) == 0) {
            for (int k = 0; k < UniformInt.m_146622_((int)1, (int)2).m_142270_(this.m_21187_()); ++k) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, (double)this.m_146901_().m_123341_() + 0.5, (double)this.m_146901_().m_123342_() + 0.8, (double)this.m_146901_().m_123343_() + 0.5, (double)(Mth.m_144924_((Random)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_144924_((Random)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083333336f));
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42410_ || stack.m_41720_() == HedgehogItems.KIWI.get();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mob) {
        HedgehogEntity hedgehog = (HedgehogEntity)((EntityType)HedgehogEntities.HEDGEHOG.get()).m_20615_((Level)world);
        UUID uuid = this.m_142504_();
        if (uuid != null) {
            hedgehog.m_21816_(uuid);
            hedgehog.m_7105_(true);
        }
        return hedgehog;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(animal instanceof HedgehogEntity)) {
            return false;
        }
        HedgehogEntity hedgehog = (HedgehogEntity)animal;
        if (!hedgehog.m_21824_()) {
            return false;
        }
        if (hedgehog.m_21825_()) {
            return false;
        }
        return this.m_27593_() && hedgehog.m_27593_();
    }

    public boolean m_7757_(LivingEntity target, LivingEntity entity) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            if (target instanceof HedgehogEntity) {
                HedgehogEntity hedgehog = (HedgehogEntity)target;
                return !hedgehog.m_21824_() || hedgehog.m_142480_() != entity;
            }
            if (target instanceof Player && entity instanceof Player && !((Player)entity).m_7099_((Player)target)) {
                return false;
            }
            if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
                return false;
            }
            return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
        }
        return false;
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        int i;
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float g = (float)this.m_21133_(Attributes.f_22282_);
        if (entity instanceof LivingEntity) {
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
            g += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (bl = entity.m_6469_((DamageSource)new EntityDamageSource(String.format("mob.%s", new ResourceLocation("hedgehog", "hedgehog")), (Entity)this), damage)) {
            if (g > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147240_((double)(g * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return bl;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public static class HedgehogLookControl
    extends LookControl {
        private final HedgehogEntity entity;

        public HedgehogLookControl(HedgehogEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void m_8128_() {
            if (this.entity.getScaredTicks() == 0) {
                super.m_8128_();
            }
        }
    }

    public static class HedgehogMoveControl
    extends MoveControl {
        private final HedgehogEntity entity;

        public HedgehogMoveControl(HedgehogEntity mob) {
            super((Mob)mob);
            this.entity = mob;
        }

        public void m_8126_() {
            if (this.entity.getScaredTicks() == 0) {
                super.m_8126_();
            }
        }
    }
}

