/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.hedgehog.world.gen;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.orcinus.hedgehog.blocks.KiwiVinesBlock;
import net.orcinus.hedgehog.init.HedgehogBlocks;
import net.orcinus.hedgehog.world.gen.KiwiVinesFeature;

public class HedgehogBirchTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public HedgehogBirchTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        Random random = context.m_159776_();
        int height = ConstantInt.m_146483_((int)9).m_142270_(random);
        if (!world.m_8055_(blockPos.m_7495_()).m_60620_((Tag)BlockTags.f_144274_)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockPos placePos = blockPos.m_6630_(i);
            if (!world.m_7433_(placePos, state -> state.m_60713_((Block)HedgehogBlocks.KIWI.get()) || state.m_60767_().m_76336_() || state.m_60795_() || state.m_60713_(Blocks.f_49990_) || state.m_60767_() == Material.f_76300_)) continue;
            world.m_7731_(placePos, Blocks.f_50001_.m_49966_(), 19);
            this.generateVines((LevelAccessor)world, random, placePos);
        }
        int radius = 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -4; y <= 4; ++y) {
                    BlockPos leavePos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y + height, blockPos.m_123343_() + z);
                    if (!(0.4 * (double)(x * x) + (double)(y * y) / 16.0 + 0.4 * (double)(z * z) <= (double)(radius * radius)) || !world.m_7433_(leavePos, DripstoneUtils::m_159664_)) continue;
                    BlockState state2 = Blocks.f_50052_.m_49966_();
                    world.m_7731_(leavePos, state2, 19);
                }
            }
        }
        return true;
    }

    private void generateVines(LevelAccessor world, Random random, BlockPos pos) {
        BlockPos.MutableBlockPos mut = pos.m_122032_();
        if (random.nextInt(3) == 0) {
            KiwiVinesFeature.generateVine(world, pos, random, 2);
        }
        for (Direction direction : Direction.values()) {
            BlockState state;
            BlockPos relative = mut.m_142300_(direction);
            BlockState blockState = state = random.nextBoolean() ? (BlockState)((Block)HedgehogBlocks.KIWI.get()).m_49966_().m_61124_((Property)KiwiVinesBlock.KIWI, (Comparable)Boolean.valueOf(true)) : ((Block)HedgehogBlocks.KIWI.get()).m_49966_();
            if (!random.nextBoolean() || !world.m_46859_(relative)) continue;
            world.m_7731_(relative, (BlockState)state.m_61124_((Property)KiwiVinesBlock.m_153933_((Direction)direction.m_122424_()), (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

