/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.hedgehog.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.hedgehog.client.models.HedgehogModel;
import net.orcinus.hedgehog.client.models.HedgehogScaredModel;
import net.orcinus.hedgehog.client.renderers.layers.HedgehogClothLayer;
import net.orcinus.hedgehog.entities.HedgehogEntity;
import net.orcinus.hedgehog.init.HedgehogModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class HedgehogRenderer
extends MobRenderer<HedgehogEntity, EntityModel<HedgehogEntity>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("hedgehog", "textures/entity/hedgehog.png");
    public static final ResourceLocation SCARED_TEXTURE = new ResourceLocation("hedgehog", "textures/entity/scared_hedgehog.png");
    public static final ResourceLocation SPEED_CONSUMER = new ResourceLocation("hedgehog", "textures/entity/speed_consumer_hedgehog.png");
    public static final ResourceLocation SCARED_SPEED_CONSUMER = new ResourceLocation("hedgehog", "textures/entity/scared_speed_consumer_hedgehog.png");
    public static final ResourceLocation ZEFIRO = new ResourceLocation("hedgehog", "textures/entity/zefiro_hedgehog.png");
    public static final ResourceLocation SCARED_ZEFIRO = new ResourceLocation("hedgehog", "textures/entity/scared_zefiro_hedgehog.png");
    private final EntityModel<HedgehogEntity> scared;
    private final EntityModel<HedgehogEntity> normal = this.m_7200_();

    public HedgehogRenderer(EntityRendererProvider.Context context) {
        super(context, new HedgehogModel(context.m_174023_(HedgehogModelLayers.HEDGEHOG)), 0.4f);
        this.scared = new HedgehogScaredModel(context.m_174023_(HedgehogModelLayers.HEDGEHOG_SCARED));
        this.m_115326_(new HedgehogClothLayer(this, context.m_174027_()));
    }

    protected void setupRotations(HedgehogEntity entity, PoseStack stack, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_((LivingEntity)entity, stack, animationProgress, bodyYaw, tickDelta);
        if (entity.m_20069_()) {
            stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            stack.m_85845_(Vector3f.f_122222_.m_122240_(20.0f));
            stack.m_85837_(0.0, -0.6, -0.1);
        }
    }

    public void render(HedgehogEntity entity, float p_115456_, float p_115457_, PoseStack stack, MultiBufferSource source, int packedLight) {
        this.f_115290_ = entity.getScaredTicks() > 0 ? this.scared : this.normal;
        if (entity.m_21825_()) {
            stack.m_85837_(0.0, -0.04, 0.0);
        }
        super.m_7392_((Mob)entity, p_115456_, p_115457_, stack, source, packedLight);
    }

    public ResourceLocation getTextureLocation(HedgehogEntity entity) {
        String s = ChatFormatting.m_126649_((String)entity.m_7755_().getString());
        if ("SpeedBoy".equals(s)) {
            return entity.getScaredTicks() > 0 ? SCARED_SPEED_CONSUMER : SPEED_CONSUMER;
        }
        if ("Zefiro".equals(s)) {
            return entity.getScaredTicks() > 0 ? SCARED_ZEFIRO : ZEFIRO;
        }
        return entity.getScaredTicks() > 0 ? SCARED_TEXTURE : TEXTURE;
    }
}

