/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.hedgehog.world.gen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5821;
import net.minecraft.class_6016;
import net.orcinus.hedgehog.blocks.KiwiVinesBlock;
import net.orcinus.hedgehog.init.HedgehogBlocks;
import net.orcinus.hedgehog.world.gen.KiwiVinesFeature;
import org.apache.commons.compress.utils.Lists;

public class HedgehogBirchTreeFeature
extends class_3031<class_3111> {
    public HedgehogBirchTreeFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 world = context.method_33652();
        class_2338 blockPos = context.method_33655();
        Random random = context.method_33654();
        int height = class_6016.method_34998((int)9).method_35008(random);
        if (!world.method_8320(blockPos.method_10074()).method_26164(class_3481.field_29822)) {
            return false;
        }
        ArrayList vinePlacePos = Lists.newArrayList();
        for (int i = 0; i <= height; ++i) {
            class_2338 placePos = blockPos.method_10086(i);
            if (!world.method_16358(placePos, state -> state.method_27852(HedgehogBlocks.KIWI_VINES) || state.method_26207().method_15800() || state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_26207() == class_3614.field_15935)) continue;
            world.method_8652(placePos, class_2246.field_10511.method_9564(), 19);
            vinePlacePos.add(placePos);
        }
        int radius = 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -4; y <= 4; ++y) {
                    class_2338 leavePos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + y + height, blockPos.method_10260() + z);
                    if (!(0.4 * (double)(x * x) + (double)(y * y) / 16.0 + 0.4 * (double)(z * z) <= (double)(radius * radius)) || !world.method_16358(leavePos, class_5726::method_33014)) continue;
                    class_2680 state2 = class_2246.field_10539.method_9564();
                    world.method_8652(leavePos, state2, 19);
                }
            }
        }
        for (class_2338 vinePos : vinePlacePos) {
            this.generateVines((class_1936)world, random, vinePos);
        }
        return true;
    }

    private void generateVines(class_1936 world, Random random, class_2338 pos) {
        class_2338.class_2339 mut = pos.method_25503();
        if (random.nextInt(3) == 0) {
            KiwiVinesFeature.generateVine(world, pos, random, 2);
        }
        for (class_2350 direction : class_2350.values()) {
            class_2680 state;
            class_2338 offset = mut.method_10093(direction);
            class_2680 class_26802 = state = random.nextBoolean() ? (class_2680)HedgehogBlocks.KIWI_VINES.method_9564().method_11657((class_2769)KiwiVinesBlock.KIWI, (Comparable)Boolean.valueOf(true)) : HedgehogBlocks.KIWI_VINES.method_9564();
            if (!random.nextBoolean() || !world.method_22347(offset)) continue;
            world.method_8652(offset, (class_2680)state.method_11657((class_2769)KiwiVinesBlock.method_33374((class_2350)direction.method_10153()), (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

