/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client;

import net.lavabucket.hourglass.time.Time;
import net.lavabucket.hourglass.wrappers.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TimeInterpolator {
    public static TimeInterpolator instance;
    public final ClientLevelWrapper level;
    private boolean initialized;
    private long targetTime;
    private float timeVelocity;
    private long lastTime;
    private float lastPartialTickTime;

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (ClientLevelWrapper.isClientLevel(event.getWorld())) {
            ClientLevelWrapper level = new ClientLevelWrapper(event.getWorld());
            instance = new TimeInterpolator(level);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (instance != null && ((ClientWorld)TimeInterpolator.instance.level.get()).equals(event.getWorld())) {
            instance = null;
        }
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && !minecraft.func_147113_T() && instance != null && ((ClientWorld)TimeInterpolator.instance.level.get()).equals(minecraft.field_71441_e)) {
            instance.partialTick(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public static void OnClientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && !minecraft.func_147113_T() && instance != null && ((ClientWorld)TimeInterpolator.instance.level.get()).equals(minecraft.field_71441_e)) {
            instance.undoVanillaTimeTicks();
        }
    }

    public TimeInterpolator(ClientLevelWrapper level) {
        this.level = level;
        this.initialized = false;
    }

    private void init() {
        long time;
        this.targetTime = time = ((ClientWorld)this.level.get()).func_72820_D();
        this.lastTime = time;
        this.initialized = true;
    }

    public void partialTick(float partialTickTime) {
        if (!this.initialized) {
            this.init();
        }
        float tickTimeDelta = this.getPartialTimeDelta(partialTickTime);
        this.updateTargetTime();
        this.interpolateTime(tickTimeDelta);
    }

    private float getPartialTimeDelta(float partialTickTime) {
        float partialTimeDelta = partialTickTime - this.lastPartialTickTime;
        if (partialTimeDelta < 0.0f) {
            partialTimeDelta += 1.0f;
        }
        this.lastPartialTickTime = partialTickTime;
        return partialTimeDelta;
    }

    private void interpolateTime(float tickTimeDelta) {
        long time = ((ClientWorld)this.level.get()).func_72820_D();
        float duration = 1.0f;
        float omega = 2.0f;
        float x = 2.0f * tickTimeDelta;
        float exp = 1.0f / (1.0f + x + 0.48f * x * x + 0.235f * x * x * x);
        float change = time - this.targetTime;
        float temp = (this.timeVelocity + 2.0f * change) * tickTimeDelta;
        time = this.targetTime + (long)((change + temp) * exp);
        this.timeVelocity = (this.timeVelocity - 2.0f * temp) * exp;
        if (change < 0.0f == time > this.targetTime) {
            time = this.targetTime;
            this.timeVelocity = 0.0f;
        }
        this.setDayTime(time);
    }

    private void updateTargetTime() {
        long time = ((ClientWorld)this.level.get()).func_72820_D();
        if (time != this.lastTime) {
            this.targetTime = time;
            long discrepancy = this.lastTime - time;
            if (Math.abs(discrepancy) > 24000L) {
                long newTimeOfDay = Time.timeOfDay(time);
                long oldTimeOfDay = Time.timeOfDay(this.lastTime);
                this.lastTime = time - newTimeOfDay + oldTimeOfDay;
            }
            ((ClientWorld)this.level.get()).func_72877_b(this.lastTime);
        }
    }

    private void setDayTime(long time) {
        ((ClientWorld)this.level.get()).func_72877_b(time);
        this.lastTime = time;
    }

    private void undoVanillaTimeTicks() {
        if (this.level.daylightRuleEnabled()) {
            ((ClientWorld)this.level.get()).func_72877_b(((ClientWorld)this.level.get()).func_72820_D() - 1L);
        }
    }
}

